xquery version "1.0" encoding "UTF-8";

module namespace loan="http://www.fpml.org/2008/FpML-4-5/loan";

declare default element namespace "http://www.fpml.org/2008/FpML-4-5";
import schema namespace fpml="http://www.fpml.org/2008/FpML-4-5" at "../../schema/fpml-main.xsd"; 
import schema namespace val="http://www.fpml.org/2008/FpML-4-5/validation" at "Validation.xsd";

import module namespace res="http://www.fpml.org/2008/FpML-4-5/results" at "fpml-results.xq";
import module namespace fun="http://www.fpml.org/2008/FpML-4-5/functions" at "fpml-functions.xq";

declare function loan:multipleLenderLoanContractPeriod($interestAccrualSchedule as element(*, InterestAccrualSchedule)) as xs:boolean
(: More than one lenderLoanContractPeriod exists for the InterestAccrualSchedule. :)
{
	count($interestAccrualSchedule/lenderLoanContractPeriod) gt 1
}; 

declare function loan:multipleInterestRatePeriod($interestAccrualSchedule as element(*, InterestAccrualSchedule)) as xs:boolean
(: More than one interestRatePeriod exists for the InterestAccrualSchedule. :)
{
	count($interestAccrualSchedule/interestRatePeriod) gt 1
}; 

declare function loan:multipleInterestAccrualPeriod($interestAccrualSchedule as element(*, InterestAccrualSchedule)) as xs:boolean
(: More than one interestAccrualPeriod exists for the InterestAccrualSchedule. :)
{
	count($interestAccrualSchedule/interestAccrualPeriod) gt 1
}; 

declare variable $loan:evaluation as document-node(element(val:documentEvaluation)) := validate strict{
	document {
		element val:documentEvaluation {
		
for $loanContract in //element(*, LoanContract)
return res:pretty-result(xs:NMTOKEN("ln-1"), $loanContract/currentInterestRatePeriod/startDate ge $loanContract/effectiveDate, $loanContract, ())
,
for $loanContract in //element(*, LoanContract)[currentInterestRatePeriod/floatingRateIndex eq xs:normalizedString("PRIME")]
return res:pretty-result(xs:NMTOKEN("ln-2"), $loanContract/currentInterestRatePeriod/rateFixingDate eq $loanContract/effectiveDate, $loanContract, ())
,
for $interestRatePeriod in //element(*, InterestRatePeriod)
return res:pretty-result(xs:NMTOKEN("ln-3"), ($interestRatePeriod/endDate ge $interestRatePeriod/startDate) and ($interestRatePeriod/startDate ge $interestRatePeriod/rateFixingDate), $interestRatePeriod, ())
,
for $interestRatePeriod in //element(*, InterestRatePeriod)[not(exists(mandatoryCostRate))][exists(interestRate)][exists(margin)][exists(allInRate)]
return res:pretty-result(xs:NMTOKEN("ln-4"), $interestRatePeriod/allInRate eq ($interestRatePeriod/margin + $interestRatePeriod/interestRate), $interestRatePeriod, ())
,
for $interestRatePeriod in //element(*, InterestRatePeriod)[exists(mandatoryCostRate)][exists(interestRate)][exists(margin)][exists(allInRate)]
return res:pretty-result(xs:NMTOKEN("ln-5"), $interestRatePeriod/allInRate eq ($interestRatePeriod/margin + $interestRatePeriod/interestRate + $interestRatePeriod/mandatoryCostRate), $interestRatePeriod, ())
, 
(: ln-6 is broken. See issue: http://www.fpml.org/issues/view.php?id=737
Context: InterestAccrualSchedule (complex type)
ln-6 (Mandatory)
interestRatePeriod/startDate,lenderLoanContractPeriod/startDate, interestAccrualPeriod/startDate must be equal in each period. 
:)
(:
ln-7 (Mandatory)
Preconditions: MultipleInterestRatePeriod
The [n]th interestRatePeriod/endDate must be the previous calendar day of the [n+1]th interestRatePeriod/startDate.
Test cases: [Invalid]
:)
for $interestAccrualSchedule in //element(*, InterestAccrualSchedule)[loan:multipleInterestRatePeriod(.)]
return res:pretty-result(xs:NMTOKEN("ln-7"), every $startDate in $interestAccrualSchedule/interestRatePeriod[position() > 1]/startDate satisfies $startDate - xs:dayTimeDuration("P1D") = $interestAccrualSchedule/interestRatePeriod/endDate, $interestAccrualSchedule, ())
,
for $interestAccrualSchedule in //element(*, InterestAccrualSchedule)[loan:multipleLenderLoanContractPeriod(.)]
return res:pretty-result(xs:NMTOKEN("ln-8"), every $startDate in $interestAccrualSchedule/lenderLoanContractPeriod[position() > 1]/startDate satisfies $startDate - xs:dayTimeDuration("P1D") = $interestAccrualSchedule/lenderLoanContractPeriod/endDate, $interestAccrualSchedule, ("See issue: http://www.fpml.org/issues/view.php?id=743"))
,
for $interestAccrualSchedule in //element(*, InterestAccrualSchedule)[loan:multipleInterestAccrualPeriod(.)]
return res:pretty-result(xs:NMTOKEN("ln-9"), every $startDate in $interestAccrualSchedule/interestAccrualPeriod[position() > 1]/startDate satisfies $startDate - xs:dayTimeDuration("P1D") = $interestAccrualSchedule/interestAccrualPeriod/endDate, $interestAccrualSchedule, ())
,
for $drawdownNotice in //element(*, DrawdownNotice)
return res:pretty-result(xs:NMTOKEN("ln-13"), $drawdownNotice/noticeDate le $drawdownNotice/drawdownPayment/paymentDate, $drawdownNotice, ())
,
for $drawdownNotice in //element(*, DrawdownNotice)[exists(loanContract)]
return res:pretty-result(xs:NMTOKEN("ln-14"), $drawdownNotice/drawdownPayment/paymentDate ge $drawdownNotice/loanContract/effectiveDate, $drawdownNotice, ())
(:
,
http://www.fpml.org/issues/view.php?id=786
for $drawdownNotice in //element(*, DrawdownNotice)[exists(dealIdentifier/creditAgreementDate)]
return res:pretty-result(xs:NMTOKEN("ln-15"), ($drawdownNotice/loanContract/effectiveDate ge $drawdownNotice/dealIdentifier/creditAgreementDate) and ($drawdownNotice/drawdownPayment/paymentDate ge $drawdownNotice/dealIdentifier/creditAgreementDate), $drawdownNotice, ())
:)
,
for $drawdownNotice in //element(*, DrawdownNotice)[exists(facilityCommitmentPosition/priorAmount/shareAmount)] [fun:same-currency((facilityCommitmentPosition/priorAmount/shareAmount,drawdownPayment/shareLoanContractAmount))]
return res:pretty-result(xs:NMTOKEN("ln-16"), $drawdownNotice/drawdownPayment/shareLoanContractAmount/amount le $drawdownNotice/facilityCommitmentPosition/priorAmount/shareAmount/amount, $drawdownNotice, ())
,
for $drawdownNotice in //element(*, DrawdownNotice)[exists(loanContract)] [fun:same-currency((loanContract/amount/amount,drawdownPayment/shareLoanContractAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-17"), $drawdownNotice/loanContract/amount/amount ge $drawdownNotice/drawdownPayment/shareLoanContractAmount/amount, $drawdownNotice, ())
,
for $drawdownNotice in //element(*, DrawdownNotice)[exists(loanContractSummary)][fun:same-currency((loanContractSummary/originalAmount/amount,drawdownPayment/shareLoanContractAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-18"), $drawdownNotice/loanContractSummary/originalAmount/amount ge $drawdownNotice/drawdownPayment/shareLoanContractAmount/amount, $drawdownNotice, ())
,
for $drawdownNotice in //element(*, DrawdownNotice)[drawdownEventType eq xs:token("RateSetEvent")] [exists(loanContract)]
return res:pretty-result(xs:NMTOKEN("ln-19"), (exists($drawdownNotice/loanContract/currentInterestRatePeriod/interestRate) and exists($drawdownNotice/loanContract/currentInterestRatePeriod/margin) and exists($drawdownNotice/loanContract/currentInterestRatePeriod/allInRate) and exists($drawdownNotice/loanContract/currentInterestRatePeriod/interestDayBasis) and exists($drawdownNotice/loanContract/currentInterestRatePeriod/indexTenor)), $drawdownNotice, ())
,
for $interestPaymentNotice in //element(*, InterestPaymentNotice)[fun:same-currency((interestPayment/amount/shareAmount/amount,//interestAccrualSchedule/interestAccrualPeriod/shareInterestAccrualAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-20"), ($interestPaymentNotice/interestPayment/amount/shareAmount/amount eq sum($interestPaymentNotice/interestAccrualSchedule/interestAccrualPeriod/shareInterestAccrualAmount/amount)), $interestPaymentNotice, ())
,
for $interestPaymentNotice in //element(*, InterestPaymentNotice)
return res:pretty-result(xs:NMTOKEN("ln-21"), (exists($interestPaymentNotice/interestAccrualSchedule/interestRatePeriod/interestRate) and exists($interestPaymentNotice/interestAccrualSchedule/interestRatePeriod/margin) and exists($interestPaymentNotice/interestAccrualSchedule/interestRatePeriod/allInRate) and exists($interestPaymentNotice/interestAccrualSchedule/interestRatePeriod/interestDayBasis) and exists($interestPaymentNotice/interestAccrualSchedule/interestRatePeriod/indexTenor)), $interestPaymentNotice, ())
,
for $loanContractRepayment in //element(*, LoanContractRepayment)[exists(loanContractSummary/originalAmount)] [fun:same-currency((loanContractSummary/originalAmount/amount,amount/globalAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-22"), ($loanContractRepayment/loanContractSummary/originalAmount/amount ge $loanContractRepayment/amount/globalAmount/amount), $loanContractRepayment, ())
,
for $repayment in //element(*, Repayment)[fun:same-currency((facilityRepayment/amount/globalAmount/amount,//loanContractRepayment/loanContractSummary/originalAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-23"), ($repayment/facilityRepayment/amount/globalAmount/amount ge sum($repayment/loanContractRepayment/loanContractSummary/originalAmount/amount)), $repayment, ())
,
for $repaymentNotice in //element(*, RepaymentNotice)[exists(facilityCommitmentPosition)] [fun:same-currency((facilityCommitmentPosition/priorAmount/shareAmount/amount,repayment/facilityRepayment/amount/shareAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-24"), ($repaymentNotice/facilityCommitmentPosition/priorAmount/shareAmount/amount ge $repaymentNotice/repayment/facilityRepayment/amount/shareAmount/amount), $repaymentNotice, ())
,
for $repayment  in //element(*, Repayment)[fun:same-currency((facilityRepayment/amount/shareAmount/amount,//loanContractRepayment/amount/shareAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-25"), ($repayment/facilityRepayment/amount/shareAmount/amount ge sum($repayment/loanContractRepayment/amount/shareAmount/amount)), $repayment, ())
,
for $repayment  in //element(*, Repayment)[exists(loanContractRepayment/amount/globalAmount)] [fun:same-currency((facilityRepayment/amount/globalAmount/amount,//loanContractRepayment/amount/globalAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-26"), ($repayment/facilityRepayment/amount/globalAmount/amount ge sum($repayment/loanContractRepayment/amount/globalAmount/amount)), $repayment, ())
,
for $oneOffFeeNotice  in //element(*, OneOffFeeNotice)[feePayment/feeType eq xs:token("BreakageFee")]
return res:pretty-result(xs:NMTOKEN("ln-27"), (exists(loanContractSummary)), $oneOffFeeNotice, ())
,
for $oneOffFeeNotice  in //element(*, OneOffFeeNotice)[feePayment/feeType eq xs:token("AssignmentFee")]
return res:pretty-result(xs:NMTOKEN("ln-28"), (not(exists(loanContractSummary))), $oneOffFeeNotice, ())
,
for $oneOffFeePayment  in //element(*, OneOffFeePayment)
return res:pretty-result(xs:NMTOKEN("ln-29"), ($oneOffFeePayment/paymentDate ge $oneOffFeePayment/effectiveDate), $oneOffFeePayment, ())
,
for $facilityNotice  in //element(*, FacilityNotice)[exists(facilityCommitmentPosition/loanContractPosition/currentAmount/globalAmount)][exists(facilityCommitmentPosition/currentAmount/globalAmount)][fun:same-currency((facilityCommitmentPosition/currentAmount/globalAmount/amount,//facilityCommitmentPosition/loanContractPosition/currentAmount/globalAmount))]
return res:pretty-result(xs:NMTOKEN("ln-30"), ($facilityNotice/facilityCommitmentPosition/currentAmount/globalAmount/amount ge sum($facilityNotice/facilityCommitmentPosition/loanContractPosition/currentAmount/globalAmount/amount)), $facilityNotice, ())
,
for $facilityNotice  in //element(*, FacilityNotice)[exists(facilityCommitmentPosition/loanContractPosition/priorAmount/globalAmount)] [exists(facilityCommitmentPosition/priorAmount/globalAmount)] [fun:same-currency((facilityCommitmentPosition/priorAmount/globalAmount/amount,//facilityCommitmentPosition/loanContractPosition/priorAmount/globalAmount/amount))]
return res:pretty-result(xs:NMTOKEN("ln-31"), ($facilityNotice/facilityCommitmentPosition/priorAmount/globalAmount/amount ge sum($facilityNotice/facilityCommitmentPosition/loanContractPosition/priorAmount/globalAmount/amount)), $facilityNotice, ())
		}
	}
};