xquery version "1.0" encoding "UTF-8";
(: $Id: fpml-invariants-4-4-3.xq 154 2008-04-30 15:50:19Z u424971 $ :)

module namespace fun="http://www.fpml.org/2008/FpML-4-5/functions";

declare construction preserve;
declare copy-namespaces no-preserve, inherit;

declare default element namespace "http://www.fpml.org/2008/FpML-4-5"; 
import schema namespace fpml="http://www.fpml.org/2008/FpML-4-5" at "../../schema/fpml-main.xsd"; 

declare variable $fun:isParametric as xs:boolean := every $interestRateStream in //element(*, InterestRateStream) satisfies (not(exists($interestRateStream/..//cashflows)) or ($interestRateStream/cashflows/cashflowsMatchParameters eq true())); 

declare function fun:same-currency($money as element()*) as xs:boolean
(: Are all instances of a currency within these money elements are the same currency.
In Saxon-SA the signature would be declare function fun:same-currency($money as fpml:Money()*) as xs:boolean  :)
{
	(count(distinct-values($money/currency)) le 1) and  (count(distinct-values($money/currency/@currencyScheme)) le 1)
};

declare function fun:modulo-duration($dividendPeriodMultiplier as xs:integer, $dividendPeriod as xs:string, $divisorPeriodMultiplier as xs:integer, $divisorPeriod as xs:string) as xs:integer?
(: Return the mod of the duration in the smallest period supplied :)
{
	if ($dividendPeriod eq $divisorPeriod)
	then ($dividendPeriodMultiplier mod $divisorPeriodMultiplier)
	else if ($dividendPeriod eq "M" and $divisorPeriod eq "Y")
		then ($dividendPeriodMultiplier mod ($divisorPeriodMultiplier * 12))
		else if ($dividendPeriod eq "Y" and $divisorPeriod eq "M")
			then (($dividendPeriodMultiplier * 12) mod $divisorPeriodMultiplier)
			else if ($dividendPeriod eq "D" and $divisorPeriod eq "W")
				then ($dividendPeriodMultiplier mod ($divisorPeriodMultiplier * 7))
				else if ($dividendPeriod eq "W" and $divisorPeriod eq "D")
					then (($dividendPeriodMultiplier * 7) mod $divisorPeriodMultiplier * 12)
					else ()
};

declare function fun:absent($arg as item()*) as xs:boolean
(: Return the not of exists :)
{
	not(exists($arg))
};

declare function fun:iff($p as xs:boolean, $q as xs:boolean) as xs:boolean
(: Return the logical "if and only if" :)
{
	$p eq $q
};

declare function fun:frequency-equivalence($dividendPeriodMultiplier as xs:integer, $dividendPeriod as xs:string, $divisorPeriodMultiplier as xs:integer, $divisorPeriod as xs:string) as xs:boolean?
(: Are the two frequencies known to be always equivalent :)
{
	if ($dividendPeriod eq $divisorPeriod)
	then ($dividendPeriodMultiplier eq $divisorPeriodMultiplier)
	else if ($dividendPeriod eq "M" and $divisorPeriod eq "Y")
		then ($dividendPeriodMultiplier eq ($divisorPeriodMultiplier * 12))
		else if ($dividendPeriod eq "Y" and $divisorPeriod eq "M")
			then (($dividendPeriodMultiplier * 12) eq $divisorPeriodMultiplier)
			else if ($dividendPeriod eq "D" and $divisorPeriod eq "W")
				then ($dividendPeriodMultiplier eq ($divisorPeriodMultiplier * 7))
				else if ($dividendPeriod eq "W" and $divisorPeriod eq "D")
					then (($dividendPeriodMultiplier * 7) eq $divisorPeriodMultiplier * 12)
					else (false())
};

declare variable $fun:creditIndexPreCondition as xs:boolean := fn:exists(//creditDefaultSwap/generalTerms/indexReferenceInformation) and not(exists(//creditDefaultSwap/generalTerms/indexReferenceInformation/tranche));

declare variable $fun:singleNamePreCondition as xs:boolean := exists(//creditDefaultSwap/generalTerms/referenceInformation);

declare variable $fun:sameCurrencyPreCondition as xs:boolean := count(distinct-values(//element(*, Money)/currency)) le 1;

declare variable $fun:longFormPreCondition as xs:boolean := (count(//documentation/(masterConfirmation|contractualMatrix)) eq 0 ) and $fun:singleNamePreCondition;

declare variable $fun:shortFormPreCondition as xs:boolean := exists(//documentation[masterConfirmation|contractualMatrix|contractualTermsSupplement[matches (type, "^(iTraxx|CDX)")]]);

declare variable $fun:iSDA2003PreCondition as xs:boolean := (some $contractualDefinitions in //documentation/contractualDefinitions satisfies starts-with($contractualDefinitions, "ISDA2003Credit")) or (matches(//documentation/masterConfirmation/masterConfirmationType, "^(ISDA2003Credit|ISDA2004Credit)"));

declare variable $fun:iSDA1999PreCondition as xs:boolean := some $document in (//element(*, Trade)|//element(*, Contract))/documentation/(contractualDefinitions|masterConfirmation/masterConfirmationType) satisfies contains($document, "ISDA1999Credit");


