xquery version "1.0" encoding "UTF-8";

module namespace ird="http://www.fpml.org/2008/FpML-4-5/ird";

declare default element namespace "http://www.fpml.org/2008/FpML-4-5";
import schema namespace fpml="http://www.fpml.org/2008/FpML-4-5" at "../../schema/fpml-main.xsd"; 
import schema namespace val="http://www.fpml.org/2008/FpML-4-5/validation" at "Validation.xsd";

import module namespace res="http://www.fpml.org/2008/FpML-4-5/results" at "fpml-results.xq";
import module namespace fun="http://www.fpml.org/2008/FpML-4-5/functions" at "fpml-functions.xq";

declare variable $ird:evaluation as document-node(element(fun:documentEvaluation)) := validate strict{
	document {
		element fun:documentEvaluation {

(for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[exists(calculationPeriodAmount/calculation/(floatingRateCalculation|inflationRateCalculation))]
return res:pretty-result(xs:NMTOKEN("ird-1"), exists($interestRateStream/resetDates), $interestRateStream, ()))
, 
(for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[$fun:isParametric]
return res:pretty-result(xs:NMTOKEN("ird-2"), fun:modulo-duration($interestRateStream/paymentDates/paymentFrequency/periodMultiplier, $interestRateStream/paymentDates/paymentFrequency/period, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/periodMultiplier, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/period)=0, $interestRateStream, ()))
,
(: to be implemented
TODO unadjusted calculation period dates is complex to work out!

ird-3 (Mandatory)
Preconditions: isParametric
paymentDates/firstPaymentDate must match one of the unadjusted calculation period dates.

ird-4 (Mandatory)
Preconditions: isParametric
paymentDates/lastRegularPaymentDate must match one of the unadjusted calculation period dates
:)

(: The FpML rule is bust. It should take into account whether it is a resetting swapStream or not because $interestRateStream/resetDates is optional. An issue is raised for this: http://www.fpml.org/issues/view.php?id=613
(for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[$fun:isParametric]
return <result constraint="ird-5" valid="{fun:modulo-duration($interestRateStream/calculationPeriodDates/calculationPeriodFrequency/periodMultiplier, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/period, $interestRateStream/resetDates/resetFrequency/periodMultiplier, $interestRateStream/resetDates/resetFrequency/period)=0}"></result>)

ird-5 (Mandatory)
Preconditions: isParametric
The frequency in calculationPeriodDates/calculationPeriodFrequencymust be an integer multiple of the frequency in resetDates/resetFrequency. See also: frequency equivalence
:)

(: This FpML rule is bust. Two issues are raised against it: http://www.fpml.org/issues/view.php?id=614 http://www.fpml.org/issues/view.php?id=615.
(for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[$fun:isParametric]
return <result constraint="ird-6" valid="{$interestRateStream/paymentDates/firstPaymentDate > $interestRateStream/calculationPeriodDates/effectiveDate/unadjustedDate}"></result>)
ird-6 (Mandatory)
Preconditions: isParametric
paymentDates/firstPaymentDate > calculationPeriodDates/effectiveDate/unadjustedDate.
:)
(for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[$fun:isParametric]
return res:pretty-result(xs:NMTOKEN("ird-7"), fun:iff(exists($interestRateStream/calculationPeriodAmount/calculation/compoundingMethod), not (fun:frequency-equivalence($interestRateStream/paymentDates/paymentFrequency/periodMultiplier, $interestRateStream/paymentDates/paymentFrequency/period, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/periodMultiplier, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/period))), $interestRateStream, ()))
,
(for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)
return res:pretty-result(xs:NMTOKEN("ird-8"), $interestRateStream/payerPartyReference/@href ne $interestRateStream/receiverPartyReference/@href, $interestRateStream, ()))
,
(for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)
return res:pretty-result(xs:NMTOKEN("ird-9"), if (exists($interestRateStream/calculationPeriodAmount/calculation/compoundingMethod)) then exists($interestRateStream/resetDates) else true(), $interestRateStream, ()))


(: IRD Constraints to be implemented. All of these constraints are broken in some way. Most are not yet based on types.

ird-10 (Mandatory)
Preconditions: isParametric
This rule applies when calculationPeriodFrequency/rollConvention is a number. Let the start date be firstRegularPeriodStartDate if it exists, or effectiveDate/unadjustedDate otherwise: If calculationPeriodFrequency/rollConvention is less than or equal to the last day of the month in the start date, then the day of the start date must match it. Otherwise the day of the start date must be the last day of the month of that date.
Test cases: [Valid] [Valid] [Valid] [Valid] [Valid] [Invalid] [Invalid] [Invalid] [Invalid]
ird-11 (Mandatory)
Preconditions: isParametric
This rule applies when calculationPeriodFrequency/rollConvention is a number. Let the end date be lastRegularPeriodEndDate if it exists, or terminationDate/unadjustedDate otherwise: If calculationPeriodFrequency/rollConvention is less than or equal to the last day of the month in the end date, then the day of the end date must match it. Otherwise the day of the end date must be the last day of the month of that date.
Test cases: [Valid] [Valid] [Valid] [Valid] [Valid] [Invalid] [Invalid] [Invalid] [Invalid] [Invalid]
ird-12 (Mandatory)
Preconditions: isParametric
The frequency specified in calculationPeriodFrequency must divide the regular period precisely. This means that by stepping through the period from the start date at the specified frequency, it must be possible to reach the end date.
Test cases: [Valid] [Valid] [Valid] [Valid] [Invalid] [Invalid] [Invalid] [Invalid] [Invalid] [Invalid]
ird-14 (Mandatory)
Preconditions: isParametric
terminationDate/unadjustedDate > effectiveDate/unadjustedDate.
Test cases: [Valid] [Invalid] [Invalid]
ird-15 (Mandatory)
Preconditions: isParametric
terminationDate/unadjustedDate > firstPeriodStartDate/unadjustedDate.
Test cases: [Valid] [Invalid] [Invalid]
ird-16 (Mandatory)
Preconditions: isParametric
terminationDate/unadjustedDate > firstRegularPeriodStartDate.
Test cases: [Valid] [Invalid] [Invalid]
ird-17 (Mandatory)
Preconditions: isParametric
terminationDate/unadjustedDate > lastRegularPeriodEndDate.
Test cases: [Valid] [Invalid]
ird-18 (Mandatory)
Preconditions: isParametric
lastRegularPeriodEndDate > firstRegularPeriodStartDate.
Test cases: [Valid] [Invalid] [Invalid]
ird-19 (Mandatory)
Preconditions: isParametric
lastRegularPeriodEndDate > firstPeriodStartDate/unadjustedDate.
Test cases: [Valid] [Invalid] [Invalid]
ird-20 (Mandatory)
Preconditions: isParametric
lastRegularPeriodEndDate > effectiveDate/unadjustedDate
Test cases: [Valid] [Invalid]
ird-21 (Mandatory)
Preconditions: isParametric
firstPeriodStartDate/unadjustedDate < effectiveDate/unadjustedDate
Test cases: [Valid] [Invalid] [Invalid]
ird-22 (Mandatory)
Preconditions: isParametric
firstPeriodStartDate/unadjustedDate < firstRegularPeriodStartDate
Test cases: [Valid] [Invalid] [Invalid]
ird-57 (Mandatory)
Preconditions: isParametric
If rollConvention is neither NONE nor SFE, nor a day of the week ( MON, TUE, WED, THU, FRI, SAT or SUN) then the period must be M or Y.
Test cases: [Valid] [Valid] [Valid] [Valid] [Invalid]
ird-58 (Mandatory)
Preconditions: isParametric
If rollConvention is a day of the week ( MON, TUE, WED, THU, FRI, SAT or SUN) then the period must be W.
Test cases: [Valid] [Valid] [Valid] [Valid] [Invalid]
Context: stubCalculationPeriodAmount
ird-23 (Mandatory)
initialStub should only be present if the calculationPeriodDates element referenced by calculationPeriodDates/@href contains at least one of:

    * firstPeriodStartDate
    * firstRegularPeriodStartDate

Test cases: [Valid] [Valid] [Invalid]
ird-24 (Mandatory)
finalStub should only be present if the calculationPeriodDates element referenced by calculationPeriodDates/@href contains a lastRegularPeriodEndDate element.
Test cases: [Valid] [Invalid]
Context: Schedule (complex type)
ird-25 (Mandatory)
If there are no step elements then initialValue must be non-zero.
Test cases: [Valid] [Valid] [Invalid]
Context: businessCentersReference
ird-26 (Mandatory)
The @href attribute must match the @id attribute of a businessCenters element somewhere within the document.
Test cases: [Valid] [Valid] [Invalid] [Invalid]
Context: MandatoryEarlyTermination (complex type)
ird-27 (Mandatory)
cashSettlement/cashSettlementPaymentDate must not be present.
Test cases: [Valid] [Invalid]
ird-28 (Mandatory)
In cashSettlement/cashSettlementValuationDate/dateRelativeTo, the @href attribute must point to the @id attribute of mandatoryEarlyTerminationDate.
Test cases: [Valid] [Invalid]
Context: Calculation (complex type)
ird-29 (Mandatory)
If compoundingMethod is present then fixedRateSchedule must not be present.
Test cases: [Valid] [Invalid]
Context: CalculationPeriod (complex type)
ird-30 (Mandatory)
Must contain unadjustedStartDate and/or adjustedStartDate.
Test cases: [Valid] [Valid] [Invalid]
ird-31 (Mandatory)
Must contain unadjustedEndDate and/or adjustedEndDate.
Test cases: [Valid] [Valid] [Invalid]



Context: notionalStepSchedule
ird-50 (Mandatory)
Preconditions: isParametric
The dates in step/stepDate must be unadjusted calculation period dates in ../../../../calculationPeriodDates.
Test cases: [Valid] [Valid] [Invalid] [Invalid] [Invalid]
Context: fixedRateSchedule
ird-51 (Mandatory)
Preconditions: isParametric
The dates in step/stepDate must be unadjusted calculation period dates in ../../../calculationPeriodDates.
Test cases: [Valid] [Valid] [Invalid] [Invalid] [Invalid] [Invalid]
Context: capRateSchedule
ird-52 (Mandatory)
Preconditions: isParametric
The dates in step/stepDate must be unadjusted calculation period dates in ../../../../calculationPeriodDates.
Test cases: [Valid] [Valid] [Invalid] [Invalid] [Invalid] [Invalid]
Context: floorRateSchedule
ird-53 (Mandatory)
Preconditions: isParametric
The dates in step/stepDate must be unadjusted calculation period dates in ../../../../calculationPeriodDates.
Test cases: [Valid] [Valid] [Invalid] [Invalid] [Invalid] [Invalid]
Context: knownAmountSchedule
ird-54 (Mandatory)
Preconditions: isParametric
The dates in step/stepDate must be unadjusted calculation period dates in ../../calculationPeriodDates.
Test cases: [Valid] [Valid] [Invalid] [Invalid] [Invalid] [Invalid]
Context: paymentDates
ird-55 (Mandatory)
If calculationPeriodDatesReference exists, the @href attribute must point to the @id attribute of calculationPeriodDates in the same swapStream.
Test cases: [Valid] [Invalid]
ird-56 (Mandatory)
If resetDatesReference exists, the @href attribute must point to the @id attribute of resetDates in the same swapStream.
Test cases: [Valid] [Invalid]
Context: resetDates
ird-59 (Mandatory)
In calculationPeriodDatesReference, the @href attribute must point to the @id attribute of calculationPeriodDates in the same swapStream.


Context: PaymentDates (complex type)
ird-36 (Mandatory)
This rule has the problem that paymentFrequency duration is  a different type to the difference between the dates.
If both firstPaymentDate and lastRegularPaymentDate are present then the period defined by these dates must be an integer multiple of paymentFrequency.
Test cases: [Valid] [Invalid]


:)
,
(for $discounting as element(*, Discounting) in //element(*, Discounting)
return res:pretty-result(xs:NMTOKEN("ird-32"), if (fun:absent($discounting/discountRate)) then (fun:absent($discounting/discountRateDayCountFraction)) else true(), $discounting, ("The example invalid-ird-32-00.xml is broken. It is not schema valid. Please see the issues:  http://www.fpml.org/issues/view.php?id=650"))) 
,
(for $fra as element(*, Fra) in //element(*, Fra)
return res:pretty-result(xs:NMTOKEN("ird-33"), $fra/adjustedTerminationDate gt $fra/adjustedEffectiveDate, $fra, ())) 
,
(for $paymentCalculationPeriod as element(*, PaymentCalculationPeriod) in //element(*, PaymentCalculationPeriod)
return res:pretty-result(xs:NMTOKEN("ird-34"), exists($paymentCalculationPeriod/(unadjustedPaymentDate|adjustedPaymentDate)), $paymentCalculationPeriod, ())) 
,
(for $paymentDates as element(*, PaymentDates) in //element(*, PaymentDates)[exists(firstPaymentDate)][exists(lastRegularPaymentDate)]
return res:pretty-result(xs:NMTOKEN("ird-35"), xs:boolean($paymentDates/firstPaymentDate lt $paymentDates/lastRegularPaymentDate), $paymentDates, ())) 
,
(for $stubCalculationPeriodAmount as element(*, StubCalculationPeriodAmount) in //element(*, StubCalculationPeriodAmount)
return res:pretty-result(xs:NMTOKEN("ird-38"), exists($stubCalculationPeriodAmount/(initialStub|finalStub)), $stubCalculationPeriodAmount, ())) 
,
(for $earlyTerminationEvent as element(*, EarlyTerminationEvent) in //element(*, EarlyTerminationEvent)
return res:pretty-result(xs:NMTOKEN("ird-39"), $earlyTerminationEvent/adjustedExerciseDate le $earlyTerminationEvent/adjustedEarlyTerminationDate, $earlyTerminationEvent, ())) 
,
(for $earlyTerminationEvent as element(*, EarlyTerminationEvent) in //element(*, EarlyTerminationEvent)
return res:pretty-result(xs:NMTOKEN("ird-40"), $earlyTerminationEvent/adjustedExerciseDate le $earlyTerminationEvent/adjustedCashSettlementValuationDate, $earlyTerminationEvent, ())) 
,
(for $earlyTerminationEvent as element(*, EarlyTerminationEvent) in //element(*, EarlyTerminationEvent)
return res:pretty-result(xs:NMTOKEN("ird-41"), $earlyTerminationEvent/adjustedCashSettlementValuationDate le $earlyTerminationEvent/adjustedCashSettlementPaymentDate, $earlyTerminationEvent, ())) 
,
(for $extensionEvent as element(*, ExtensionEvent) in //element(*, ExtensionEvent)
return res:pretty-result(xs:NMTOKEN("ird-42"), $extensionEvent/adjustedExerciseDate lt $extensionEvent/adjustedExtendedTerminationDate, $extensionEvent, ())) 
,
(for $fxLinkedNotionalAmount as element(*, FxLinkedNotionalAmount) in //element(*, FxLinkedNotionalAmount)
return res:pretty-result(xs:NMTOKEN("ird-43"), exists($fxLinkedNotionalAmount/element()), $fxLinkedNotionalAmount, ())) 
,
(for $mandatoryEarlyTerminationAdjustedDates as element(*, MandatoryEarlyTerminationAdjustedDates) in //element(*, MandatoryEarlyTerminationAdjustedDates)
return res:pretty-result(xs:NMTOKEN("ird-44"), ($mandatoryEarlyTerminationAdjustedDates/adjustedEarlyTerminationDate le $mandatoryEarlyTerminationAdjustedDates/adjustedCashSettlementValuationDate) and ($mandatoryEarlyTerminationAdjustedDates/adjustedCashSettlementValuationDate le $mandatoryEarlyTerminationAdjustedDates/adjustedCashSettlementPaymentDate), $mandatoryEarlyTerminationAdjustedDates, ())) 
,
(for $optionalEarlyTermination as element(*, OptionalEarlyTermination) in //element(*, OptionalEarlyTermination)[cashSettlement/cashSettlementValuationDate]
return res:pretty-result(xs:NMTOKEN("ird-46"), (if (exists($optionalEarlyTermination/cashSettlement/cashSettlementPaymentDate))  then ($optionalEarlyTermination/cashSettlement/cashSettlementValuationDate/dateRelativeTo/@href eq $optionalEarlyTermination/cashSettlement/cashSettlementPaymentDate/@id) else false()), $optionalEarlyTermination, ())) 
,
(for $optionalEarlyTermination as element(*, OptionalEarlyTermination) in //element(*, OptionalEarlyTermination)[exists(cashSettlement/cashSettlementPaymentDate/relativeDate)]
return res:pretty-result(xs:NMTOKEN("ird-47"), $optionalEarlyTermination/cashSettlement/cashSettlementPaymentDate/relativeDate/dateRelativeTo/@href eq $optionalEarlyTermination/(americanExercise|bermudaExercise|europeanExercise)/@id, $optionalEarlyTermination, ("See issue: http://www.fpml.org/issues/view.php?id=647"))) 
,
(for $swaption as element(*, Swaption) in //element(*, Swaption)[exists(cashSettlement/cashSettlementPaymentDate)]
return res:pretty-result(xs:NMTOKEN("ird-48"), $swaption/cashSettlement/cashSettlementPaymentDate/relativeDate/dateRelativeTo/@href eq $swaption/(americanExercise|bermudaExercise|europeanExercise)/@id, $swaption, ())) 
,
(for $resetFrequency as element(*, ResetFrequency) in //element(*, ResetFrequency)
return res:pretty-result(xs:NMTOKEN("ird-49"), fun:iff(exists($resetFrequency/weeklyRollConvention), ($resetFrequency/period eq "W")), $resetFrequency, ())) 
		}	
	}
};