xquery version "1.0" encoding "UTF-8";

module namespace shd="http://www.fpml.org/2008/FpML-4-5/shared";

declare default element namespace "http://www.fpml.org/2008/FpML-4-5";
import schema namespace fpml="http://www.fpml.org/2008/FpML-4-5" at "../../schema/fpml-main.xsd"; 
import schema namespace val="http://www.fpml.org/2008/FpML-4-5/validation" at "Validation.xsd";

import module namespace res="http://www.fpml.org/2008/FpML-4-5/results" at "fpml-results.xq";
import module namespace fun="http://www.fpml.org/2008/FpML-4-5/functions" at "fpml-functions.xq";

declare variable $shd:evaluation as document-node(element(val:documentEvaluation)) := validate strict{
	document {
		element val:documentEvaluation {

for $businessDayAdjustments as element(*, BusinessDayAdjustments) in //element(*, BusinessDayAdjustments) 
let $businessCentersPresent as xs:boolean := exists($businessDayAdjustments[businessCentersReference|businessCenters]) 
let $businessDayConventionNotSet as xs:boolean := not($businessDayAdjustments/businessDayConvention = (xs:string("NONE"), xs:string("NotApplicable"))) 
return res:pretty-result(xs:NMTOKEN("shared-1"), $businessCentersPresent eq $businessDayConventionNotSet, $businessDayAdjustments, ())
, 
for $relativeDateOffset as element(*, RelativeDateOffset) in //element(*, RelativeDateOffset)[dayType = xs:string("Business")] 
return res:pretty-result(xs:NMTOKEN("shared-4"), $relativeDateOffset/businessDayConvention eq xs:string("NONE"), $relativeDateOffset, ())
, 
for $payerReceiver as element() in (//element(*,DirectionalLeg), //element(*,EquityPremium), //element(*,ExerciseFee), //element(*,ExerciseFeeSchedule), //element(*,FeaturePayment), //element(*,FxOptionPremium), //element(*,GrossCashflow), //element(*,IndependentAmount), //element(*,InitialPayment), //element(*,InterestRateStream), //element(*,PassThroughItem), //element(*,Payment), //element(*,PaymentBase), //element(*,PaymentMatching), //element(*,PrePayment), //element(*,PrincipalExchangeDescriptions), //element(*,QuotablePayment), //element(*,ReturnSwapAdditionalPayment), //element(*,ReturnSwapLeg), //element(*,SimplePayment))
return res:pretty-result(xs:NMTOKEN("shared-5"), $payerReceiver/receiverPartyReference/@href ne $payerReceiver/payerPartyReference/@href, $payerReceiver, ())
, 
for $americanExercise as element(*, AmericanExercise) in //element(*, AmericanExercise)[exists(latestExerciseTime)] 
return res:pretty-result(xs:NMTOKEN("shared-6"), $americanExercise/earliestExerciseTime/hourMinuteTime lt $americanExercise/latestExerciseTime/hourMinuteTime, $americanExercise, ())
, 
for $bermudaExercise as element(*, BermudaExercise) in //element(*, BermudaExercise)[exists(latestExerciseTime)] 
return res:pretty-result(xs:NMTOKEN("shared-7"), $bermudaExercise/earliestExerciseTime/hourMinuteTime lt $bermudaExercise/latestExerciseTime/hourMinuteTime, $bermudaExercise, ())
, 
for $dateRange as element(*, DateRange) in //element(*, DateRange) 
return res:pretty-result(xs:NMTOKEN("shared-8"), $dateRange/unadjustedFirstDate lt $dateRange/unadjustedLastDate, $dateRange, ())
, 
for $businessDateRange as element(*, BusinessDateRange) in //element(*, BusinessDateRange)[fun:iff(exists(businessCentersReference), exists(businessCenters))]
return res:pretty-result(xs:NMTOKEN("shared-9"), $businessDateRange = (xs:string("NONE"), xs:string("NotApplicable")), $businessDateRange, ())
, 
for $calculationAgent as element(*, CalculationAgent) in //element(*, CalculationAgent)
return res:pretty-result(xs:NMTOKEN("shared-10"), count(distinct-values($calculationAgent/calculationAgentPartyReference/@href)) eq count($calculationAgent/calculationAgentPartyReference/@href), $calculationAgent, ())
, 
for $trade as element(*, Trade) in //element(*, Trade)[exists(//businessDateRange)]
return res:pretty-result(xs:NMTOKEN("shared-11"), every $businessCentersReference in $trade//businessCentersReference satisfies $businessCentersReference/@href = $trade//businessCenters/@id, $trade, ())
,
for $document as element(*, Document) in //element(*, Document)
return res:pretty-result(xs:NMTOKEN("shared-12"), every $buyerPartyReference in $document//buyerPartyReference satisfies $buyerPartyReference/@href  = $document/(tradeSide/@id, party/@id), $document, ())
,
for $document as element(*, Document) in //element(*, Document)
return res:pretty-result(xs:NMTOKEN("shared-13"), every $sellerPartyReference in $document//sellerPartyReference satisfies $sellerPartyReference/@href  = $document/(tradeSide/@id, party/@id), $document, ())
,
for $document as element(*, Document) in //element(*, Document)
return res:pretty-result(xs:NMTOKEN("shared-14"), every $calculationAgentPartyReference in $document//calculationAgentPartyReference satisfies $calculationAgentPartyReference/@href = $document/party/@id, $document, ())
,
for $offset as element(*, Offset) in //element(*, Offset)[exists(dayType)] 
return res:pretty-result(xs:NMTOKEN("shared-15"), fun:iff(($offset/period eq xs:string("D")), ($offset/periodMultiplier ne 0)), $offset, ())
,
for $document as element(*, Document) in //element(*, Document)
return res:pretty-result(xs:NMTOKEN("shared-16"), every $party in $document/trade/tradeSide/*/party satisfies $party/@href = $document/party/@id, $document, ("http://www.fpml.org/issues/view.php?id=752"))
, 
for $document as element(*, Document) in //element(*, Document)
return res:pretty-result(xs:NMTOKEN("shared-17"), every $account in $document/trade/tradeSide/*/account satisfies $account/@href = $document/party/account/@id, $document, ("http://www.fpml.org/issues/view.php?id=752"))
		}	
	}
};