xquery version "1.0" encoding "UTF-8";
(: $Id: fpml-functions.xq 4819 2008-09-18 16:16:29Z matthew $ :)

module namespace fun="http://www.fpml.org/2009/FpML-4-6/functions";

declare construction preserve;
declare copy-namespaces no-preserve, inherit;

declare default element namespace "http://www.fpml.org/2009/FpML-4-6"; 
import schema namespace fpml="http://www.fpml.org/2009/FpML-4-6" at "fpml-infoset.xsd"; 

declare variable $fun:isParametric as xs:boolean := every $interestRateStream in //element(*, InterestRateStream) satisfies (not(exists($interestRateStream/..//cashflows)) or ($interestRateStream/cashflows/cashflowsMatchParameters eq true())); 

declare function fun:lastDateOfMonth($dt as xs:date) as xs:date
(: Returns the last date of the month the date is in. For example for 2006-02-10 it returns 2006-02-28 :)
{
	  if (month-from-date($dt) eq month-from-date($dt + xs:dayTimeDuration("P1D")))
		then  fun:lastDateOfMonth($dt + xs:dayTimeDuration("P1D"))
	  else
	    $dt
};

declare function fun:regularPeriod($cpd as element(*, CalculationPeriodDates)) as element(period)
(: The regular period of a set of calculation period dates is the period between a start date and an end date. If firstRegularPeriodStartDate exists, then the start date is firstRegularPeriodStartDate, else the start date is effectiveDate/unadjustedDate. If lastRegularPeriodEndDate exists, then the end date is lastRegularPeriodEndDate, else the end date is terminationDate/unadjustedDate. :)
{ 
	validate strict {
		element period {
			element startDate {
				if (exists($cpd/firstRegularPeriodStartDate))
					then data($cpd/firstRegularPeriodStartDate)
				else
					data($cpd/effectiveDate/unadjustedDate)
			},
			element endDate {
				if (exists($cpd/lastRegularPeriodEndDate))
					then data($cpd/lastRegularPeriodEndDate)
				else
					data($cpd/terminationDate/unadjustedDate)
			}
		}
	}
};

declare function fun:same-currency($money as element()*) as xs:boolean
(: Are all instances of a currency within these money elements are the same currency.
In Saxon-SA the signature would be declare function fun:same-currency($money as fpml:Money()*) as xs:boolean  :)
{
	(count(distinct-values($money/currency)) le 1) and  (count(distinct-values($money/currency/@currencyScheme)) le 1)
};

declare function fun:isParametric($stream as element(*, InterestRateStream)) as xs:boolean
(: If cashflows does not exist , or cashflows/cashflowsMatchParameters is true, then it is a Parametric definition. :)
{
	not(exists($stream/cashflows)) or ($stream/cashflows/cashflowsMatchParameters eq true())
};

declare function fun:modulo-duration($dividendPeriodMultiplier as xs:integer, $dividendPeriod as xs:string, $divisorPeriodMultiplier as xs:integer, $divisorPeriod as xs:string) as xs:integer?
(: Return the mod of the duration in the smallest period supplied :)
{
	if ($dividendPeriod eq $divisorPeriod)
	then ($dividendPeriodMultiplier mod $divisorPeriodMultiplier)
	else if ($dividendPeriod eq "M" and $divisorPeriod eq "Y")
		then ($dividendPeriodMultiplier mod ($divisorPeriodMultiplier * 12))
		else if ($dividendPeriod eq "Y" and $divisorPeriod eq "M")
			then (($dividendPeriodMultiplier * 12) mod $divisorPeriodMultiplier)
			else if ($dividendPeriod eq "D" and $divisorPeriod eq "W")
				then ($dividendPeriodMultiplier mod ($divisorPeriodMultiplier * 7))
				else if ($dividendPeriod eq "W" and $divisorPeriod eq "D")
					then (($dividendPeriodMultiplier * 7) mod $divisorPeriodMultiplier * 12)
					else ()
};

declare function fun:absent($arg as item()*) as xs:boolean
(: Return the not of exists :)
{
	not(exists($arg))
};

declare function fun:iff($p as xs:boolean, $q as xs:boolean) as xs:boolean
(: Return the logical "if and only if" :)
{
	$p eq $q
};

declare function fun:frequency-equivalence($dividendPeriodMultiplier as xs:integer, $dividendPeriod as xs:string, $divisorPeriodMultiplier as xs:integer, $divisorPeriod as xs:string) as xs:boolean?
(: Are the two frequencies known to be always equivalent :)
{
	if ($dividendPeriod eq $divisorPeriod)
	then ($dividendPeriodMultiplier eq $divisorPeriodMultiplier)
	else if ($dividendPeriod eq "M" and $divisorPeriod eq "Y")
		then ($dividendPeriodMultiplier eq ($divisorPeriodMultiplier * 12))
		else if ($dividendPeriod eq "Y" and $divisorPeriod eq "M")
			then (($dividendPeriodMultiplier * 12) eq $divisorPeriodMultiplier)
			else if ($dividendPeriod eq "D" and $divisorPeriod eq "W")
				then ($dividendPeriodMultiplier eq ($divisorPeriodMultiplier * 7))
				else if ($dividendPeriod eq "W" and $divisorPeriod eq "D")
					then (($dividendPeriodMultiplier * 7) eq $divisorPeriodMultiplier * 12)
					else (false())
};

declare function fun:intervalAsDayTimeDuration($i as element(*, Interval)) as xs:dayTimeDuration?
(: Returns an Interval as a duration if possible, otherwise returns nothing :)
{
	if ($i/period eq fpml:PeriodEnum("D"))
		then xs:duration(concat('P', $i/periodMultiplier, "D"))
	else if ($i/period eq fpml:PeriodEnum("W"))
		then xs:duration(concat('P', $i/periodMultiplier * 7, "D"))
	else ()	
};

declare variable $fun:creditIndexPreCondition as xs:boolean := fn:exists(//creditDefaultSwap/generalTerms/indexReferenceInformation) and not(exists(//creditDefaultSwap/generalTerms/indexReferenceInformation/tranche));

declare variable $fun:singleNamePreCondition as xs:boolean := exists(//creditDefaultSwap/generalTerms/referenceInformation);

declare variable $fun:sameCurrencyPreCondition as xs:boolean := count(distinct-values(//element(*, Money)/currency)) le 1;

declare variable $fun:longFormPreCondition as xs:boolean := (count(//documentation/(masterConfirmation|contractualMatrix)) eq 0 ) and $fun:singleNamePreCondition;

declare variable $fun:shortFormPreCondition as xs:boolean := exists(//documentation[masterConfirmation|contractualMatrix|contractualTermsSupplement[matches (type, "^(iTraxx|CDX)")]]);

declare variable $fun:iSDA2003PreCondition as xs:boolean := (some $contractualDefinitions in //documentation/contractualDefinitions satisfies starts-with($contractualDefinitions, "ISDA2003Credit")) or (matches(//documentation/masterConfirmation/masterConfirmationType, "^(ISDA2003Credit|ISDA2004Credit)"));

declare variable $fun:iSDA1999PreCondition as xs:boolean := some $document in (//element(*, Trade)|//element(*, Contract))/documentation/(contractualDefinitions|masterConfirmation/masterConfirmationType) satisfies contains($document, "ISDA1999Credit");


