xquery version "1.0" encoding "UTF-8";
(: $Id: fpml-results.xq 4761 2008-09-15 10:23:26Z matthew $ :)

module namespace res="http://www.fpml.org/2009/FpML-4-6/results";

declare copy-namespaces no-preserve, inherit;
declare construction strip;

declare default element namespace "http://www.fpml.org/2009/FpML-4-6"; 

import schema namespace val="http://www.fpml.org/2009/FpML-4-6/validation" at "Validation.xsd";

declare function res:pretty-result($constraintName as xs:NMTOKEN, $satisfied as xs:boolean, $evaluationContext as element(), $caveat as xs:string?) as document-node(element(val:contextEvaluation))
(: Pretty prints in XML the results of a rule evaluation. The context is only shown when the constraint is not satisfied :)
{
	validate strict {
		document {
			element val:contextEvaluation { 
				element val:constraint{$constraintName},
				element val:satisfied{$satisfied},
				element val:caveat{$caveat}[exists($caveat)],
				element val:context {$evaluationContext}[not($satisfied)] 
			}
		}
	}
};