xquery version "1.0" encoding "UTF-8";
(: $Id: fpml-eqd.xq 4763 2008-09-15 10:28:42Z matthew $ :)

module namespace eqd="http://www.fpml.org/2010/FpML-4-9/eqd";

declare default element namespace "http://www.fpml.org/2010/FpML-4-9";
import schema namespace fpml="http://www.fpml.org/2010/FpML-4-9" at "../../schema/fpml-main.xsd"; 
import schema namespace val="http://www.fpml.org/2010/FpML-4-9/validation" at "Validation.xsd";

import module namespace res="http://www.fpml.org/2010/FpML-4-9/results" at "fpml-results.xq";
import module namespace fun="http://www.fpml.org/2010/FpML-4-9/functions" at "fpml-functions.xq";

declare variable $eqd:evaluation as document-node(element(val:documentEvaluation)) := validate strict{
	document {
		element val:documentEvaluation {

(for $trade in //element(*, Trade)[equityOption/equityExercise/equityAmericanExercise]
return res:pretty-result(xs:NMTOKEN("eqd-1"), $trade/equityOption/equityExercise/equityAmericanExercise/commencementDate/adjustableDate/unadjustedDate eq $trade/tradeHeader/tradeDate, $trade, ()))
,
(for $trade in //element(*, Trade)[equityOption/equityExercise/equityAmericanExercise]
return res:pretty-result(xs:NMTOKEN("eqd-2"), $trade/equityOption/equityExercise/equityAmericanExercise/expirationDate/adjustableDate/unadjustedDate ge $trade/tradeHeader/tradeDate, $trade, "See issue http://www.fpml.org/issues/view.php?id=672"))
, 
(for $trade in //element(*, Trade)[equityOption/equityExercise/equityBermudaExercise]
return res:pretty-result(xs:NMTOKEN("eqd-4"), $trade/equityOption/equityExercise/equityBermudaExercise/commencementDate/adjustableDate/unadjustedDate ge $trade//tradeHeader/tradeDate, $trade, "See issue http://www.fpml.org/issues/view.php?id=672"))
,
(for $trade in //element(*, Trade)[equityOption/equityExercise/equityBermudaExercise]
return res:pretty-result(xs:NMTOKEN("eqd-5"), $trade/equityOption/equityExercise/equityBermudaExercise/expirationDate/adjustableDate/unadjustedDate ge $trade/tradeHeader/tradeDate, $trade, "See issue http://www.fpml.org/issues/view.php?id=672"))
,
(for $trade in //element(*, Trade)[equityOption/equityExercise/equityEuropeanExercise]
return res:pretty-result(xs:NMTOKEN("eqd-12"), $trade/equityOption/equityExercise/equityEuropeanExercise/expirationDate/adjustableDate/unadjustedDate ge $trade/tradeHeader/tradeDate, $trade, "See issue http://www.fpml.org/issues/view.php?id=672"))
, 
(for $trade in //element(*, Trade)[equityOption/equityPremium/paymentDate/unadjustedDate]
return res:pretty-result(xs:NMTOKEN("eqd-13"), $trade/equityOption/equityPremium/paymentDate/unadjustedDate ge $trade/tradeHeader/tradeDate, $trade, "See issue http://www.fpml.org/issues/view.php?id=672"))
, 
(for $trade in //element(*, Trade)[brokerEquityOption/equityPremium/paymentDate/unadjustedDate]
return res:pretty-result(xs:NMTOKEN("eqd-14"), $trade/brokerEquityOption/equityPremium/paymentDate/unadjustedDate ge $trade/tradeHeader/tradeDate, $trade, "See issue http://www.fpml.org/issues/view.php?id=672"))
, 
(for $equityAmericanExercise in //element(*, EquityAmericanExercise)[latestExerciseTimeType="SpecificTime"]
return res:pretty-result(xs:NMTOKEN("eqd-3"), exists($equityAmericanExercise/latestExerciseTime), $equityAmericanExercise, "See issue http://www.fpml.org/issues/view.php?id=698"))
,
(for $equityBermudaExercise in //element(*, EquityBermudaExercise)[latestExerciseTimeType="SpecificTime"]
return res:pretty-result(xs:NMTOKEN("eqd-6"), exists($equityBermudaExercise/latestExerciseTime), $equityBermudaExercise, "See issue http://www.fpml.org/issues/view.php?id=699."))
,  
(for $equityBermudaExercise in //element(*, EquityBermudaExercise)
return res:pretty-result(xs:NMTOKEN("eqd-8"), every $date in $equityBermudaExercise/bermudaExerciseDates/date satisfies ($date gt $equityBermudaExercise/commencementDate/adjustableDate/unadjustedDate), $equityBermudaExercise, ()))
, 
(for $equityBermudaExercise in //element(*, EquityBermudaExercise)
return res:pretty-result(xs:NMTOKEN("eqd-9"), every $date in $equityBermudaExercise/bermudaExerciseDates/date satisfies $date le $equityBermudaExercise/expirationDate/adjustableDate/unadjustedDate, $equityBermudaExercise, ()))
,
(for $equityBermudaExercise in //element(*, EquityBermudaExercise)
return res:pretty-result(xs:NMTOKEN("eqd-10"), count(distinct-values($equityBermudaExercise/bermudaExerciseDates/date)) eq count($equityBermudaExercise/bermudaExerciseDates/date), $equityBermudaExercise, ()))
,
(for $equityExercise in //element(*, EquityExerciseValuationSettlement)[equityValuation/valuationDate/adjustableDate][equityEuropeanExercise]
return res:pretty-result(xs:NMTOKEN("eqd-15"), $equityExercise/equityValuation/valuationDate/adjustableDate/unadjustedDate eq $equityExercise/equityEuropeanExercise/expirationDate/adjustableDate/unadjustedDate, $equityExercise, "See issue http://www.fpml.org/issues/view.php?id=700."))
,
(for $equityOption in //element(*, EquityOption)[exists(equityExercise/*/element(*, EquityMultipleExercise))][exists(numberOfOptions)]
return res:pretty-result(xs:NMTOKEN("eqd-26"), $equityOption/equityExercise/*/element(*, EquityMultipleExercise)/maximumNumberOfOptions le $equityOption/numberOfOptions, $equityOption, "See issue: http://www.fpml.org/issues/view.php?id=679"))
, 
(for $equityMultipleExercise in //element(*, EquityMultipleExercise)
return res:pretty-result(xs:NMTOKEN("eqd-27"), $equityMultipleExercise/minimumNumberOfOptions le $equityMultipleExercise/maximumNumberOfOptions, $equityMultipleExercise, ()))
,
(for $equityMultipleExercise in //element(*, EquityMultipleExercise)[integralMultipleExercise]
return res:pretty-result(xs:NMTOKEN("eqd-28"), $equityMultipleExercise/minimumNumberOfOptions mod $equityMultipleExercise/integralMultipleExercise eq 0, $equityMultipleExercise, "See issue http://www.fpml.org/issues/view.php?id=701"))
, 
(for $equityMultipleExercise in //element(*, EquityMultipleExercise)[integralMultipleExercise]
return res:pretty-result(xs:NMTOKEN("eqd-29"), $equityMultipleExercise/maximumNumberOfOptions mod $equityMultipleExercise/integralMultipleExercise eq 0, $equityMultipleExercise, "See issue http://www.fpml.org/issues/view.php?id=702."))
, 
(for $equityOption in (//element(*, EquityOption)|//element(*, EquityDerivativeShortFormBase))[equityExercise/equityBermudaExercise/equityMultipleExercise][exists(numberOfOptions)]
return res:pretty-result(xs:NMTOKEN("eqd-18"), ($equityOption/equityExercise/equityBermudaExercise/equityMultipleExercise/maximumNumberOfOptions * $equityOption/equityExercise/equityBermudaExercise/equityMultipleExercise/integralMultipleExercise) le $equityOption/numberOfOptions, $equityOption, "See issue http://www.fpml.org/issues/view.php?id=677."))
, 
(for $equityOption in (//element(*, EquityOption)|//element(*, EquityOptionTransactionSupplement))[notional][equityPremium/percentageOfNotional][equityPremium/paymentAmount][fun:same-currency((notional, equityPremium/paymentAmount))]
return res:pretty-result(xs:NMTOKEN("eqd-19"), $equityOption/equityPremium/paymentAmount/amount eq ($equityOption/notional/amount * $equityOption/equityPremium/percentageOfNotional), $equityOption, "See the issues: http://www.fpml.org/issues/view.php?id=683 and http://www.fpml.org/issues/view.php?id=677."))
,
(for $equityOption in (//element(*, EquityOption)|//element(*, EquityDerivativeShortFormBase))[numberOfOptions][optionEntitlement][equityPremium/paymentAmount][equityPremium/pricePerOption][fun:same-currency((equityPremium/pricePerOption, equityPremium/paymentAmount))]
return res:pretty-result(xs:NMTOKEN("eqd-20"), ($equityOption/equityPremium/pricePerOption/amount * $equityOption/numberOfOptions * $equityOption/optionEntitlement = $equityOption/equityPremium/paymentAmount/amount), $equityOption, "See issue #684 http://www.fpml.org/issues/view.php?id=684"))
,
(for $equityDerivativeBase in //element(*, EquityDerivativeBase)
return res:pretty-result(xs:NMTOKEN("eqd-22"), $equityDerivativeBase/buyerPartyReference/@href ne $equityDerivativeBase/sellerPartyReference/@href, $equityDerivativeBase, ()))
,
(for $trade in (//element(*, Trade)|//element(*, Contract)|//element(*, Strategy))[equityOption/equityEffectiveDate]
return res:pretty-result(xs:NMTOKEN("eqd-23"), $trade/equityOption/equityEffectiveDate ge $trade/tradeHeader/tradeDate, $trade, "See issue: http://www.fpml.org/issues/view.php?id=685"))
,
(for $averagingSchedule in //element(*, AveragingSchedule)
return res:pretty-result(xs:NMTOKEN("eqd-24"), $averagingSchedule/startDate lt $averagingSchedule/endDate, $averagingSchedule, ()))
,
(for $brokerEquityOption in //element(*, BrokerEquityOption)[exists(numberOfOptions)][exists(equityPremium/paymentAmount)][exists(equityPremium/pricePerOption)][fun:same-currency((equityPremium/paymentAmount,equityPremium/pricePerOption))]
return res:pretty-result(xs:NMTOKEN("eqd-25"), $brokerEquityOption/equityPremium/pricePerOption/amount * $brokerEquityOption/numberOfOptions eq $brokerEquityOption/equityPremium/paymentAmount/amount, $brokerEquityOption, "See issue: http://www.fpml.org/issues/view.php?id=686"))
		}	
	}
};