xquery version "1.0" encoding "UTF-8";
(: $Id: fpml-fx.xq 4917 2008-10-01 17:25:36Z matthew $ :)

module namespace fx="http://www.fpml.org/2010/FpML-4-9/fx";

declare default element namespace "http://www.fpml.org/2010/FpML-4-9";
import schema namespace fpml="http://www.fpml.org/2010/FpML-4-9" at "../../schema/fpml-main.xsd"; 
import schema namespace val="http://www.fpml.org/2010/FpML-4-9/validation" at "Validation.xsd";

import module namespace res="http://www.fpml.org/2010/FpML-4-9/results" at "fpml-results.xq";
import module namespace fun="http://www.fpml.org/2010/FpML-4-9/functions" at "fpml-functions.xq";

declare variable $fx:evaluation as document-node(element(val:documentEvaluation)) := validate strict{
	document {
		element val:documentEvaluation {
		
for $exchangeRate in //element(*, ExchangeRate)
return res:pretty-result(xs:NMTOKEN("fx-1"), $exchangeRate/rate gt 0, $exchangeRate, ())
,
for $exchangeRate in //element(*, ExchangeRate)[exists(forwardPoints)]
return res:pretty-result(xs:NMTOKEN("fx-2"), exists($exchangeRate/spotRate), $exchangeRate, ())
,
for $exchangeRate in //element(*, ExchangeRate)[exists(forwardPoints)]
return res:pretty-result(xs:NMTOKEN("fx-3"), $exchangeRate/rate eq ($exchangeRate/spotRate + $exchangeRate/forwardPoints), $exchangeRate, ())		
,
(:
fx-4, fx-5, fx-6 need same-currency-scheme changing from a condition to a function: http://www.fpml.org/issues/view.php?id=812.

fx-4 (Mandatory)
Context: ExchangeRate (complex type)
[SameCurrencyScheme]
sideRates/baseCurrency != the values of both quotedCurrencyPair/currency1 and quotedCurrencyPair/currency2.

fx-5 (Mandatory)
Context: ExchangeRate (complex type)
[SameCurrencyScheme]
sideRates/currency1SideRate/currency = quotedCurrencyPair/currency1.

fx-6 (Mandatory)
Context: ExchangeRate (complex type)
[SameCurrencyScheme]
sideRates/currency2SideRate/currency = quotedCurrencyPair/currency2
:)
for $fxAmericanTrigger in //element(*, FxAmericanTrigger)
return res:pretty-result(xs:NMTOKEN("fx-7"), $fxAmericanTrigger/triggerRate ge 0, $fxAmericanTrigger, ())		
,
for $fxAmericanTrigger in //element(*, FxAmericanTrigger)[exists(observationStartDate)] [exists(observationEndDate)]
return res:pretty-result(xs:NMTOKEN("fx-8"), $fxAmericanTrigger/observationStartDate le $fxAmericanTrigger/observationEndDate, $fxAmericanTrigger, ())	
,
for $fxAverageRateObservationSchedule in //element(*, FxAverageRateObservationSchedule)[exists(observationStartDate)] [exists(observationEndDate)]
return res:pretty-result(xs:NMTOKEN("fx-9"), $fxAverageRateObservationSchedule/observationStartDate le $fxAverageRateObservationSchedule/observationEndDate, $fxAverageRateObservationSchedule, ())	
,
for $fxAverageRateObservationSchedule in //element(*, FxAverageRateObservationSchedule)[calculationPeriodFrequency/period eq fpml:PeriodEnum('D')]
return res:pretty-result(xs:NMTOKEN("fx-10"), (($fxAverageRateObservationSchedule/observationStartDate - $fxAverageRateObservationSchedule/observationEndDate) div xs:dayTimeDuration (concat('P', $fxAverageRateObservationSchedule/calculationPeriodFrequency/periodMultiplier, 'D'))) mod 1 eq 0, $fxAverageRateObservationSchedule, ())	
,
for $fxAverageRateOption in //element(*, FxAverageRateOption)
return res:pretty-result(xs:NMTOKEN("fx-11"), count(distinct-values($fxAverageRateOption/observedRates/observationDate)) eq count($fxAverageRateOption/observedRates/observationDate), $fxAverageRateOption, ())
,
(:
fx-12 (Mandatory)
Context: FxAverageRateOption (complex type)
[exists(averageRateObservationSchedule)]
The values of observedRates/observationDate should match the calculated schedule dates derived from parameters defined within the averageRateObservationSchedule element and the business day calendar implied by fixingTime/businessCenter.
:)
for $fxAverageRateOption in //element(*, FxAverageRateOption)[exists(averageRateObservationDate)]
return res:pretty-result(xs:NMTOKEN("fx-13"), every $observationDate in $fxAverageRateOption/observedRates/observationDate satisfies $observationDate = $fxAverageRateOption/averageRateObservationDate/observationDate, $fxAverageRateOption, ())
,
for $fxBarrier in //element(*, FxBarrier)[exists(observationStartDate)] [exists(observationEndDate)]
return res:pretty-result(xs:NMTOKEN("fx-14"), $fxBarrier/observationStartDate le $fxBarrier/observationEndDate, $fxBarrier, ())
,
for $fxBarrierOption in //element(*, FxBarrierOption)[exists(spotRate)]
return res:pretty-result(xs:NMTOKEN("fx-15"), $fxBarrierOption/spotRate gt 0, $fxBarrierOption, ())
,
for $fxDigitalOption in //element(*, FxDigitalOption)[exists(spotRate)]
return res:pretty-result(xs:NMTOKEN("fx-16"), $fxDigitalOption/spotRate gt 0, $fxDigitalOption, ())
,
for $fxEuropeanTrigger in //element(*, FxEuropeanTrigger)
return res:pretty-result(xs:NMTOKEN("fx-17"), $fxEuropeanTrigger/triggerRate gt 0, $fxEuropeanTrigger, ())
,
for $fxLeg in //element(*, FxLeg)
return res:pretty-result(xs:NMTOKEN("fx-18"), $fxLeg/exchangedCurrency1/payerPartyReference/@href eq $fxLeg/exchangedCurrency2/receiverPartyReference/@href and $fxLeg/exchangedCurrency1/receiverPartyReference/@href eq $fxLeg/exchangedCurrency2/payerPartyReference/@href, $fxLeg, ())
,
for $fxLeg in //element(*, FxLeg)[fun:same-currency((exchangedCurrency1/paymentAmount,exchangedCurrency2/paymentAmount))]
return res:pretty-result(xs:NMTOKEN("fx-19"), $fxLeg/exchangedCurrency1/payerPartyReference/@href eq $fxLeg/exchangedCurrency2/receiverPartyReference/@href and $fxLeg/exchangedCurrency1/paymentAmount/currency ne $fxLeg/exchangedCurrency2/paymentAmount/currency, $fxLeg, ())
,
for $fxLeg in //element(*, FxLeg)[exists(currency1ValueDate)]
return res:pretty-result(xs:NMTOKEN("fx-20"), $fxLeg/exchangedCurrency1/payerPartyReference/@href eq $fxLeg/exchangedCurrency2/receiverPartyReference/@href and $fxLeg/currency1ValueDate ne $fxLeg/currency2ValueDate, $fxLeg, ())
,
for $fxLeg in //element(*, FxLeg)[exists(nonDeliverableForward)]
return res:pretty-result(xs:NMTOKEN("fx-21"), exists($fxLeg/exchangeRate/forwardPoints), $fxLeg, ())
,
for $fxOptionLeg in //element(*, FxOptionLeg)[exists(fxOptionPremium)]
return res:pretty-result(xs:NMTOKEN("fx-22"), $fxOptionLeg/buyerPartyReference/@href = $fxOptionLeg/fxOptionPremium/payerPartyReference/@href and $fxOptionLeg/sellerPartyReference/@href = $fxOptionLeg/fxOptionPremium/receiverPartyReference/@href, $fxOptionLeg, ())
,
for $fxOptionLeg in //element(*, FxOptionLeg)[fun:same-currency((putCurrencyAmount,callCurrencyAmount))]
return res:pretty-result(xs:NMTOKEN("fx-23"), $fxOptionLeg/putCurrencyAmount/currency ne $fxOptionLeg/callCurrencyAmount/currency, $fxOptionLeg, ())
,
for $fxStrikePrice in //element(*, FxStrikePrice)
return res:pretty-result(xs:NMTOKEN("fx-24"), $fxStrikePrice/rate gt 0, $fxStrikePrice, ())
,
for $fxSwap in //element(*, FxSwap)
return res:pretty-result(xs:NMTOKEN("fx-25"), count($fxSwap/fxSingleLeg) ge 2, $fxSwap, ())
,
for $fxSwap in //element(*, FxSwap)[count(fxSingleLeg) eq 2]
return res:pretty-result(xs:NMTOKEN("fx-26"), $fxSwap/fxSingleLeg[1]/valueDate ne $fxSwap/fxSingleLeg[2]/valueDate, $fxSwap, ())

(: See issue http://www.fpml.org/issues/view.php?id=812 - same currency scheme must be changed from a condition to a function.
,
for $quotedCurrencyPair in //element(*, QuotedCurrencyPair)[SameCurrencyScheme]
return res:pretty-result(xs:NMTOKEN("fx-27"), $quotedCurrencyPair/fxSingleLeg[1]/valueDate ne $fxSwap/fxSingleLeg[2]/valueDate, $quotedCurrencyPair, ())

fx-27 (Mandatory)
Context: QuotedCurrencyPair (complex type)
[SameCurrencyScheme]
currency1 != currency2.
:)
,
for $sideRate in //element(*, SideRate)
return res:pretty-result(xs:NMTOKEN("fx-28"), $sideRate/rate gt 0, $sideRate, ())
,
for $sideRate in //element(*, SideRate)[exists(forwardPoints)]
return res:pretty-result(xs:NMTOKEN("fx-29"), exists($sideRate/spotRate), $sideRate, ())
,
for $sideRate in //element(*, SideRate)[exists(spotRate)] [exists(forwardPoints)]
return res:pretty-result(xs:NMTOKEN("fx-30"), $sideRate/rate eq $sideRate/spotRate + $sideRate/forwardPoints, $sideRate, ())
(: See issue http://www.fpml.org/issues/view.php?id=812 - same currency scheme must be changed from a condition to a function.
,
fx-31 (Mandatory)
Context: SideRates (complex type)
[SameCurrencyScheme]
baseCurrency != the values of both currency1SideRate/currency and currency2SideRate/currency.
:)
,
for $termDeposit in //element(*, TermDeposit)
return res:pretty-result(xs:NMTOKEN("fx-32"), $termDeposit/initialPayerReference/@href ne $termDeposit/initialReceiverReference/@href, $termDeposit, ())
,
for $termDeposit in //element(*, TermDeposit)
return res:pretty-result(xs:NMTOKEN("fx-33"), $termDeposit/maturityDate gt $termDeposit/startDate, $termDeposit, ())
,
for $termDeposit in //element(*, TermDeposit)
return res:pretty-result(xs:NMTOKEN("fx-34"), $termDeposit/principal/amount gt 0, $termDeposit, ())
,
for $termDeposit in //element(*, TermDeposit)
return res:pretty-result(xs:NMTOKEN("fx-35"), $termDeposit/fixedRate gt 0, $termDeposit, ())
,
for $trade in //element(*, Trade)[exists(fxAverageRateOption)]
return res:pretty-result(xs:NMTOKEN("fx-36"), $trade/fxAverageRateOption/expiryDateTime/expiryDate gt $trade/tradeHeader/tradeDate, $trade, ())
,
for $contract in //element(*, Contract )[exists(fxAverageRateOption)]
return res:pretty-result(xs:NMTOKEN("fx-36b"), $contract/fxAverageRateOption/expiryDateTime/expiryDate gt $contract/header/contractDate, $contract, ())

(: http://www.fpml.org/issues/view.php?id=820  	 The following FX Rules require extending to support Contracts in addition to Trades.
fx-36
fx-37
fx-38
fx-39
fx-40 
,
fx-36 (Mandatory)
Context: Trade (complex type)
fxAverageRateOption/expiryDateTime/expiryDate > tradeHeader/tradeDate.
Test cases: [Invalid] [Invalid]
fx-37 (Mandatory)
Context: Trade (complex type)
fxBarrierOption/expiryDateTime/expiryDate > tradeHeader/tradeDate.
Test cases: [Invalid] [Invalid]
fx-38 (Mandatory)
Context: Trade (complex type)
fxDigitalOption/expiryDateTime/expiryDate > tradeHeader/tradeDate.
Test cases: [Invalid] [Invalid]
fx-39 (Mandatory)
Context: Trade (complex type)
The value of fxSingleLeg/valueDate or the value of both fxSingleLeg/valueDate1 and fxSingleLeg/valueDate2 > tradeHeader/tradeDate.
Test cases: [Invalid] [Invalid]
fx-40 (Mandatory)
Context: Trade (complex type)
The value of all fxSwap/fxSingleLeg/valueDate, fxswap/fxSingleLeg/valueDate1 and fxSwap/fxSingleLeg/valueDate2 instances > tradeHeader/tradeDate.
Test cases: [Invalid] [Invalid]
:)
,
for $fxBarrier in //element(*, FxBarrier)
return res:pretty-result(xs:NMTOKEN("fx-41"), $fxBarrier/triggerRate gt 0, $fxBarrier, ())
,
for $fxAverageRateOption in //element(*, FxAverageRateOption)
return res:pretty-result(xs:NMTOKEN("fx-42"), count(distinct-values($fxAverageRateOption/averageRateObservationDate/observationDate)) eq count($fxAverageRateOption/averageRateObservationDate/observationDate), $fxAverageRateOption, ())
,
for $fxAverageRateOption in //element(*, FxAverageRateOption)[fun:same-currency((putCurrencyAmount,callCurrencyAmount))]
return res:pretty-result(xs:NMTOKEN("fx-43"), $fxAverageRateOption/putCurrencyAmount/currency ne $fxAverageRateOption/callCurrencyAmount/currency, $fxAverageRateOption, ())
,
for $fxAverageRateOption in //element(*, FxAverageRateOption)[exists(fxOptionPremium)]
return res:pretty-result(xs:NMTOKEN("fx-44"), id($fxAverageRateOption/buyerPartyReference/@href) is id($fxAverageRateOption/fxOptionPremium/payerPartyReference/@href) and id($fxAverageRateOption/sellerPartyReference/@href) is id($fxAverageRateOption/fxOptionPremium/receiverPartyReference/@href), $fxAverageRateOption, ())
,
for $fxAverageRateOption in //element(*, FxAverageRateOption)[exists(fxOptionPremium)]
return res:pretty-result(xs:NMTOKEN("fx-45"), id($fxAverageRateOption/buyerPartyReference/@href) is id(fxOptionPremium/payerPartyReference/@href) and id(sellerPartyReference/@href) is id(fxOptionPremium/receiverPartyReference/@href), $fxAverageRateOption, ("http://www.fpml.org/issues/view.php?id=821"))
,
for $sideRates in //element(*, SideRates)
return res:pretty-result(xs:NMTOKEN("fx-46"), $sideRates/currency1SideRate/sideRateBasis = (fpml:SideRateBasisEnum("BaseCurrencyPerCurrency1"),fpml:SideRateBasisEnum("Currency1PerBaseCurrency")), $sideRates, ())
,
for $sideRates in //element(*, SideRates)
return res:pretty-result(xs:NMTOKEN("fx-47"), $sideRates/currency2SideRate/sideRateBasis = (fpml:SideRateBasisEnum("BaseCurrencyPerCurrency2"), fpml:SideRateBasisEnum("Currency2PerBaseCurrency")), $sideRates, ())
		}	
	}
};