xquery version "1.0" encoding "UTF-8";
(: $Id: fpml-ird.xq 4819 2008-09-18 16:16:29Z matthew $ :)

module namespace ird="http://www.fpml.org/2010/FpML-4-9/ird";

declare default element namespace "http://www.fpml.org/2010/FpML-4-9";
import schema namespace fpml="http://www.fpml.org/2010/FpML-4-9" at "fpml-infoset.xsd"; 
import schema namespace val="http://www.fpml.org/2010/FpML-4-9/validation" at "Validation.xsd";

import module namespace res="http://www.fpml.org/2010/FpML-4-9/results" at "fpml-results.xq";
import module namespace fun="http://www.fpml.org/2010/FpML-4-9/functions" at "fpml-functions.xq";

declare variable $ird:evaluation as document-node(element(val:documentEvaluation)) := validate strict{
	document {
		element val:documentEvaluation {

for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[exists(calculationPeriodAmount/calculation/(floatingRateCalculation|inflationRateCalculation))]
return res:pretty-result(xs:NMTOKEN("ird-1"), exists($interestRateStream/resetDates), $interestRateStream, ())
, 
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[$fun:isParametric]
return res:pretty-result(xs:NMTOKEN("ird-2"), fun:modulo-duration($interestRateStream/paymentDates/paymentFrequency/periodMultiplier, $interestRateStream/paymentDates/paymentFrequency/period, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/periodMultiplier, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/period)=0, $interestRateStream, ())
,
(: Add ird-3, ird-4, ird-5, ird-6 :)
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[$fun:isParametric]
return res:pretty-result(xs:NMTOKEN("ird-7"), fun:iff(exists($interestRateStream/calculationPeriodAmount/calculation/compoundingMethod), not (fun:frequency-equivalence($interestRateStream/paymentDates/paymentFrequency/periodMultiplier, $interestRateStream/paymentDates/paymentFrequency/period, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/periodMultiplier, $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/period))), $interestRateStream, ())
,
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)
return res:pretty-result(xs:NMTOKEN("ird-8"), $interestRateStream/payerPartyReference/@href ne $interestRateStream/receiverPartyReference/@href, $interestRateStream, ())
,
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)
return res:pretty-result(xs:NMTOKEN("ird-9"), if (exists($interestRateStream/calculationPeriodAmount/calculation/compoundingMethod)) then exists($interestRateStream/resetDates) else true(), $interestRateStream, ())
,
(: number(xyz) eq number(xyz) returns true if xyz is a number and false otherwise because NaN ne NaN in XPath :)
(: There are many problems with this. Please see http://www.fpml.org/issues/view.php?id=847
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)][number(calculationPeriodDates/calculationPeriodFrequency/rollConvention) eq number((calculationPeriodDates/calculationPeriodFrequency/rollConvention)] 
let $rollDayOfMonth as xs:integer := number($interestRateStream/calculationPeriodDates/calculationPeriodFrequency/rollConvention)
let $regularStartDate as xs:date := $interestRateStream/calculationPeriodDates/firstRegularPeriodStartDate
let $lastDayOfStartMonth as xs:date := fun:lastDayOfMonth($regularStartDate)
return res:pretty-result(xs:NMTOKEN("ird-10"), 
:)
(: ird-11 has the same issues as ird-10. http://www.fpml.org/issues/view.php?id=848
:)
(: ird-12 has the usual problems with dividing dayTimeDurations with months, etc. :)

for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-14"), $interestRateStream/calculationPeriodDates/terminationDate/unadjustedDate gt $interestRateStream/calculationPeriodDates/effectiveDate/unadjustedDate, $interestRateStream, ())
,
(: http://www.fpml.org/issues/view.php?id=851
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-15"), $interestRateStream/calculationPeriodDates/terminationDate/unadjustedDate gt $interestRateStream/calculationPeriodDates/firstPeriodStartDate/unadjustedDate, $interestRateStream, ())
,

for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-16"), $interestRateStream/calculationPeriodDates/terminationDate/unadjustedDate gt $interestRateStream/calculationPeriodDates/firstRegularPeriodStartDate, $interestRateStream, ())
, 
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-17"), $interestRateStream/calculationPeriodDates/terminationDate/unadjustedDate gt $interestRateStream/calculationPeriodDates/lastRegularPeriodEndDate, $interestRateStream, ())
, 
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-18"), $interestRateStream/calculationPeriodDates/lastRegularPeriodEndDate gt $interestRateStream/calculationPeriodDates/firstRegularPeriodStartDate, $interestRateStream, ())
,
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-19"), $interestRateStream/calculationPeriodDates/lastRegularPeriodEndDate gt $interestRateStream/calculationPeriodDates/firstPeriodStartDate/unadjustedDate, $interestRateStream, ())
,
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-20"), $interestRateStream/calculationPeriodDates/lastRegularPeriodEndDate gt $interestRateStream/calculationPeriodDates/effectiveDate/unadjustedDate, $interestRateStream, ())
, 
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-21"), $interestRateStream/calculationPeriodDates/firstPeriodStartDate/unadjustedDate lt $interestRateStream/calculationPeriodDates/effectiveDate/unadjustedDate, $interestRateStream, ())
,
for $interestRateStream as element(*, InterestRateStream) in //element(*, InterestRateStream)[fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-22"), $interestRateStream/calculationPeriodDates/firstPeriodStartDate/unadjustedDate lt $interestRateStream/calculationPeriodDates/firstRegularPeriodStartDate, $interestRateStream, ())
,
See issue http://www.fpml.org/issues/view.php?id=850
for $stubCalculationPeriodAmount as element(*, StubCalculationPeriodAmount) in //element(*, StubCalculationPeriodAmount)
return res:pretty-result(xs:NMTOKEN("ird-23"), fun:iff(exists($stubCalculationPeriodAmount/initialStub), exists(id($stubCalculationPeriodAmount/calculationPeriodDates/@href)/(firstPeriodStartDate|firstRegularPeriodStartDate))), $stubCalculationPeriodAmount, ())
:)
(: ird-24 has the same problems as ird-23. :)
(: Add ird  27, 29, 30 :)
for $schedule as element(*, Schedule) in //element(*, Schedule)[not(exists(step))]
return res:pretty-result(xs:NMTOKEN("ird-25"), $schedule/initialValue ne 0, $schedule, ())
,
for $mandatoryEarlyTermination  as element(*, MandatoryEarlyTermination) in //element(*, MandatoryEarlyTermination)
return res:pretty-result(xs:NMTOKEN("ird-27"), not(exists($mandatoryEarlyTermination/cashSettlement/cashSettlementPaymentDate)), $mandatoryEarlyTermination, ())
,
for $calculation  as element(*, Calculation) in //element(*, Calculation)[exists(compoundingMethod)]
return res:pretty-result(xs:NMTOKEN("ird-29"), not(exists($calculation/fixedRateSchedule)), $calculation, ())
,
for $calculationPeriod  as element(*, CalculationPeriod) in //element(*, CalculationPeriod)
return res:pretty-result(xs:NMTOKEN("ird-30"), exists($calculationPeriod/(unadjustedStartDate|adjustedStartDate)), $calculationPeriod, ())
,
for $calculationPeriod as element(*, CalculationPeriod) in //element(*, CalculationPeriod)
return res:pretty-result(xs:NMTOKEN("ird-31"), exists($calculationPeriod/(unadjustedStartDate|adjustedEndDate)), $calculationPeriod, ("http://www.fpml.org/issues/view.php?id=844"))
,
for $fra as element(*, Fra) in //element(*, Fra)
return res:pretty-result(xs:NMTOKEN("ird-33"), $fra/adjustedTerminationDate gt $fra/adjustedEffectiveDate, $fra, ())
,
for $paymentCalculationPeriod as element(*, PaymentCalculationPeriod) in //element(*, PaymentCalculationPeriod)
return res:pretty-result(xs:NMTOKEN("ird-34"), exists($paymentCalculationPeriod/(unadjustedPaymentDate|adjustedPaymentDate)), $paymentCalculationPeriod, ())
,
for $paymentDates as element(*, PaymentDates) in //element(*, PaymentDates)[exists(firstPaymentDate)][exists(lastRegularPaymentDate)]
return res:pretty-result(xs:NMTOKEN("ird-35"), xs:boolean($paymentDates/firstPaymentDate lt $paymentDates/lastRegularPaymentDate), $paymentDates, ())
,
for $paymentDates as element(*, PaymentDates) in //element(*, PaymentDates)[exists(firstPaymentDate)] [exists(lastRegularPaymentDate)][paymentFrequency/period = (fpml:PeriodEnum("D"), (fpml:PeriodEnum("W")))]
return res:pretty-result(xs:NMTOKEN("ird-36"), ($paymentDates/lastRegularPaymentDate - $paymentDates/firstPaymentDate) div fun:intervalAsDayTimeDuration($paymentDates/paymentFrequency) mod 1 eq 0, $paymentDates, ())
,
for $earlyTerminationEvent as element(*, EarlyTerminationEvent) in //element(*, EarlyTerminationEvent)
return res:pretty-result(xs:NMTOKEN("ird-39"), $earlyTerminationEvent/adjustedExerciseDate le $earlyTerminationEvent/adjustedEarlyTerminationDate, $earlyTerminationEvent, ())
,
for $earlyTerminationEvent as element(*, EarlyTerminationEvent) in //element(*, EarlyTerminationEvent)
return res:pretty-result(xs:NMTOKEN("ird-40"), $earlyTerminationEvent/adjustedExerciseDate le $earlyTerminationEvent/adjustedCashSettlementValuationDate, $earlyTerminationEvent, ())
,
for $earlyTerminationEvent as element(*, EarlyTerminationEvent) in //element(*, EarlyTerminationEvent)
return res:pretty-result(xs:NMTOKEN("ird-41"), $earlyTerminationEvent/adjustedCashSettlementValuationDate le $earlyTerminationEvent/adjustedCashSettlementPaymentDate, $earlyTerminationEvent, ())
,
for $extensionEvent as element(*, ExtensionEvent) in //element(*, ExtensionEvent)
return res:pretty-result(xs:NMTOKEN("ird-42"), $extensionEvent/adjustedExerciseDate lt $extensionEvent/adjustedExtendedTerminationDate, $extensionEvent, ())
,
for $fxLinkedNotionalAmount as element(*, FxLinkedNotionalAmount) in //element(*, FxLinkedNotionalAmount)
return res:pretty-result(xs:NMTOKEN("ird-43"), exists($fxLinkedNotionalAmount/element()), $fxLinkedNotionalAmount, ())
,
for $mandatoryEarlyTerminationAdjustedDates as element(*, MandatoryEarlyTerminationAdjustedDates) in //element(*, MandatoryEarlyTerminationAdjustedDates)
return res:pretty-result(xs:NMTOKEN("ird-44"), ($mandatoryEarlyTerminationAdjustedDates/adjustedEarlyTerminationDate le $mandatoryEarlyTerminationAdjustedDates/adjustedCashSettlementValuationDate) and ($mandatoryEarlyTerminationAdjustedDates/adjustedCashSettlementValuationDate le $mandatoryEarlyTerminationAdjustedDates/adjustedCashSettlementPaymentDate), $mandatoryEarlyTerminationAdjustedDates, ())
,
for $optionalEarlyTermination as element(*, OptionalEarlyTermination) in //element(*, OptionalEarlyTermination)[cashSettlement/cashSettlementValuationDate]
return res:pretty-result(xs:NMTOKEN("ird-46"), (if (exists($optionalEarlyTermination/cashSettlement/cashSettlementPaymentDate))  then ($optionalEarlyTermination/cashSettlement/cashSettlementValuationDate/dateRelativeTo/@href eq $optionalEarlyTermination/cashSettlement/cashSettlementPaymentDate/@id) else false()), $optionalEarlyTermination, ())
,
for $optionalEarlyTermination as element(*, OptionalEarlyTermination) in //element(*, OptionalEarlyTermination)[exists(cashSettlement/cashSettlementPaymentDate/relativeDate)]
return res:pretty-result(xs:NMTOKEN("ird-47"), $optionalEarlyTermination/cashSettlement/cashSettlementPaymentDate/relativeDate/dateRelativeTo/@href eq $optionalEarlyTermination/(americanExercise|bermudaExercise|europeanExercise)/@id, $optionalEarlyTermination, ("See issue: http://www.fpml.org/issues/view.php?id=647"))
,
for $swaption as element(*, Swaption) in //element(*, Swaption)[exists(cashSettlement/cashSettlementPaymentDate)]
return res:pretty-result(xs:NMTOKEN("ird-48"), $swaption/cashSettlement/cashSettlementPaymentDate/relativeDate/dateRelativeTo/@href eq $swaption/(americanExercise|bermudaExercise|europeanExercise)/@id, $swaption, ())
,
for $resetFrequency as element(*, ResetFrequency) in //element(*, ResetFrequency)
return res:pretty-result(xs:NMTOKEN("ird-49"), fun:iff(exists($resetFrequency/weeklyRollConvention), ($resetFrequency/period eq "W")), $resetFrequency, ())
(: ird-54, 53, 52, 51, 50 have major issues http://www.fpml.org/issues/view.php?id=841 :)
(: ird-55 is replaced by ref-8. See the issue: http://www.fpml.org/issues/view.php?id=840 :)
,
for $interestRateStream  as element(*, InterestRateStream) in //element(*, InterestRateStream)[exists(paymentDates/resetDatesReference)][exists(resetDates)]
return res:pretty-result(xs:NMTOKEN("ird-56"), id($interestRateStream/paymentDates/resetDatesReference/@href) is $interestRateStream/resetDates, $interestRateStream, ("See http://www.fpml.org/issues/view.php?id=837, http://www.fpml.org/issues/view.php?id=839"))
,
for $interestRateStream  as element(*, InterestRateStream) in //element(*, InterestRateStream)[calculationPeriodDates/calculationPeriodFrequency/rollConvention != (fpml:RollConventionEnum("NONE"), fpml:RollConventionEnum("SFE"), fpml:RollConventionEnum("MON"), fpml:RollConventionEnum("TUE"), fpml:RollConventionEnum("WED"), fpml:RollConventionEnum("THU"), fpml:RollConventionEnum("FRI"), fpml:RollConventionEnum("SAT"), fpml:RollConventionEnum("SUN"))][fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-57"), $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/period = (fpml:PeriodEnum('M'), fpml:PeriodEnum('Y')), $interestRateStream, ())
,
for $interestRateStream  as element(*, InterestRateStream) in //element(*, InterestRateStream)[calculationPeriodDates/calculationPeriodFrequency/rollConvention = (fpml:RollConventionEnum("NONE"), fpml:RollConventionEnum("SFE"), fpml:RollConventionEnum("MON"), fpml:RollConventionEnum("TUE"), fpml:RollConventionEnum("WED"), fpml:RollConventionEnum("THU"), fpml:RollConventionEnum("FRI"), fpml:RollConventionEnum("SAT"), fpml:RollConventionEnum("SUN"))][fun:isParametric(.)]
return res:pretty-result(xs:NMTOKEN("ird-58"), $interestRateStream/calculationPeriodDates/calculationPeriodFrequency/period eq fpml:PeriodEnum("W"), $interestRateStream, ())
,
for $interestRateStream  as element(*, InterestRateStream) in //element(*, InterestRateStream)[exists(resetDates)]
return res:pretty-result(xs:NMTOKEN("ird-59"), id($interestRateStream/resetDates/calculationPeriodDatesReference/@href) is $interestRateStream/calculationPeriodDates, $interestRateStream, ("Major issues with this constraint: http://www.fpml.org/issues/view.php?id=833"))

		}	
	}
};