xquery version "1.0" encoding "UTF-8";
(: $Id: fpml-ref.xq 4818 2008-09-18 10:19:48Z matthew $ :)

module namespace ref="http://www.fpml.org/2010/FpML-4-9/ref";

declare default element namespace "http://www.fpml.org/2010/FpML-4-9";
import schema namespace fpml="http://www.fpml.org/2010/FpML-4-9" at "../../schema/fpml-main.xsd"; 
import schema namespace val="http://www.fpml.org/2010/FpML-4-9/validation" at "Validation.xsd";

import module namespace res="http://www.fpml.org/2010/FpML-4-9/results" at "fpml-results.xq";
import module namespace fun="http://www.fpml.org/2010/FpML-4-9/functions" at "fpml-functions.xq";

declare variable $ref:evaluation as document-node(element(val:documentEvaluation)) := validate strict{
	document {
		element val:documentEvaluation {
		
for $assetReference as element(*, AssetReference) in //element(*, AssetReference)
return res:pretty-result(xs:NMTOKEN("ref-1"), id($assetReference/@href) instance of element(*, Asset), $assetReference, ())	
,
for $fixedRateReference as element(*, FixedRateReference) in //element(*, FixedRateReference)
return res:pretty-result(xs:NMTOKEN("ref-2"), id($fixedRateReference/@href) instance of element(*, FixedRate), $fixedRateReference, ())	
,
for $protectionTermsReference as element(*, ProtectionTermsReference) in //element(*, ProtectionTermsReference)
return res:pretty-result(xs:NMTOKEN("ref-3"), id($protectionTermsReference/@href) instance of element(*, ProtectionTerms), $protectionTermsReference, ())	
,
for $settlementTermsReference as element(*, SettlementTermsReference) in //element(*, SettlementTermsReference)
return res:pretty-result(xs:NMTOKEN("ref-4"), id($settlementTermsReference/@href) instance of element(*, SettlementTerms), $settlementTermsReference, ())	
,
for $interestLegCalculationPeriodDatesReference as element(*, InterestLegCalculationPeriodDatesReference) in //element(*, InterestLegCalculationPeriodDatesReference)
return res:pretty-result(xs:NMTOKEN("ref-7"), id($interestLegCalculationPeriodDatesReference/@href) instance of element(*, InterestLegCalculationPeriodDates), $interestLegCalculationPeriodDatesReference, ())	
,
for $calculationPeriodDatesReference as element(*, CalculationPeriodDatesReference) in //element(*, CalculationPeriodDatesReference)
return res:pretty-result(xs:NMTOKEN("ref-8"), id($calculationPeriodDatesReference/@href) instance of element(*, CalculationPeriodDates), $calculationPeriodDatesReference, ())	
,
for $interestRateStreamReference as element(*, InterestRateStreamReference) in //element(*, InterestRateStreamReference)
return res:pretty-result(xs:NMTOKEN("ref-9"), id($interestRateStreamReference/@href) instance of element(*, InterestRateStream), $interestRateStreamReference, ())	
,
for $paymentCalculationPeriod as element(*, PaymentCalculationPeriod) in //element(*, PaymentCalculationPeriod)[exists(@href)]
return res:pretty-result(xs:NMTOKEN("ref-10"), id($paymentCalculationPeriod/@href) instance of element(*, PricingStructure), $paymentCalculationPeriod, ("http://www.fpml.org/issues/view.php?id=843"))	
,
for $paymentDatesReference as element(*, PaymentDatesReference) in //element(*, PaymentDatesReference)
return res:pretty-result(xs:NMTOKEN("ref-11"), id($paymentDatesReference/@href) instance of element(*, PaymentDates), $paymentDatesReference, ())	
,
for $resetDatesReference as element(*, ResetDatesReference) in //element(*, ResetDatesReference)
return res:pretty-result(xs:NMTOKEN("ref-12"), id($resetDatesReference/@href) instance of element(*, ResetDates), $resetDatesReference, ())	
,
for $creditEventsReference as element(*, CreditEventsReference) in //element(*, CreditEventsReference)
return res:pretty-result(xs:NMTOKEN("ref-13"), id($creditEventsReference/@href) instance of element(*, CreditEvents), $creditEventsReference, ())	
,
for $cashflowFixingReference as element(*, CashflowFixingReference) in //element(*, CashflowFixingReference)
return res:pretty-result(xs:NMTOKEN("ref-14"), id($cashflowFixingReference/@href) instance of element(*, CashflowFixing), $cashflowFixingReference, ())	
,
for $cashflowObservationReference as element(*, CashflowObservationReference) in //element(*, CashflowObservationReference)
return res:pretty-result(xs:NMTOKEN("ref-15"), id($cashflowObservationReference/@href) instance of element(*, CashflowObservation), $cashflowObservationReference, ())	
,
for $stepReference as element(*, StepReference) in //element(*, StepReference)
return res:pretty-result(xs:NMTOKEN("ref-16"), id($stepReference/@href) instance of element(*, Step), $stepReference, ())	
,
for $tradeUnderlyerReference as element(*, TradeUnderlyerReference) in //element(*, TradeUnderlyerReference)
return res:pretty-result(xs:NMTOKEN("ref-17"), id($tradeUnderlyerReference/@href) instance of element(*, TradeUnderlyer), $tradeUnderlyerReference, ())	
(: See the issue http://www.fpml.org/issues/view.php?id=830
,
ref-18 (Mandatory)
Context: PricingStructurePoint (complex type)
The coordinate/generic/@href attribute = the underlyingAsset/@id attribute. 
:)
,
for $marketReference as element(*, MarketReference) in //element(*, MarketReference)
return res:pretty-result(xs:NMTOKEN("ref-19"), id($marketReference/@href) instance of element(*, Market), $marketReference, ())
,
for $pricingDataPointCoordinateReference as element(*, PricingDataPointCoordinateReference) in //element(*, PricingDataPointCoordinateReference)
return res:pretty-result(xs:NMTOKEN("ref-20"), id($pricingDataPointCoordinateReference/@href) instance of element(*, PricingDataPointCoordinate), $pricingDataPointCoordinateReference, ())
,
for $pricingParameterDerivativeReference as element(*, PricingParameterDerivativeReference) in //element(*, PricingParameterDerivativeReference)
return res:pretty-result(xs:NMTOKEN("ref-21"), id($pricingParameterDerivativeReference/@href) instance of element(*, PricingParameterDerivative), $pricingParameterDerivativeReference, ())
,
for $valuation as element(*, Valuation) in //element(*, Valuation)
return res:pretty-result(xs:NMTOKEN("ref-22"), id($valuation/@definitionRef) instance of element(*, ValuationScenario), $valuation, ())
,
for $valuationReference as element(*, ValuationReference) in //element(*, ValuationReference)
return res:pretty-result(xs:NMTOKEN("ref-23"), id($valuationReference/@href) instance of element(*, Valuation), $valuationReference, ())
,
for $valuationScenarioReference as element(*, ValuationScenarioReference) in //element(*, ValuationScenarioReference)
return res:pretty-result(xs:NMTOKEN("ref-24"), id($valuationScenarioReference/@href) instance of element(*, ValuationScenario), $valuationScenarioReference, ())
,
for $accountReference as element(*, AccountReference) in //element(*, AccountReference)
return res:pretty-result(xs:NMTOKEN("ref-25"), id($accountReference/@href) instance of element(*, Account), $accountReference, ())
,
for $businessCentersReference as element(*, BusinessCentersReference) in //element(*, BusinessCentersReference)
return res:pretty-result(xs:NMTOKEN("ref-26"), id($businessCentersReference/@href) instance of element(*, BusinessCenters), $businessCentersReference, ())
,
for $businessDayAdjustmentsReference as element(*, BusinessDayAdjustmentsReference) in //element(*, BusinessDayAdjustmentsReference)
return res:pretty-result(xs:NMTOKEN("ref-27"), id($businessDayAdjustmentsReference/@href) instance of element(*, BusinessDayAdjustments), $businessDayAdjustmentsReference, ())
,
for $legalEntityReference as element(*, LegalEntityReference) in //element(*, LegalEntityReference)
return res:pretty-result(xs:NMTOKEN("ref-28"), id($legalEntityReference/@href) instance of element(*, LegalEntity), $legalEntityReference, ())
,
for $partyReference as element(*, PartyReference) in //element(*, PartyReference)
return res:pretty-result(xs:NMTOKEN("ref-29"), id($partyReference/@href) instance of element(*, Party), $partyReference, ())
,
for $payment as element(*, Payment) in //element(*, Payment)
return res:pretty-result(xs:NMTOKEN("ref-30"), id($payment/@href) instance of element(*, PricingStructure), $payment, ())
,
for $pricingStructureReference as element(*, PricingStructureReference) in //element(*, PricingStructureReference)
return res:pretty-result(xs:NMTOKEN("ref-31"), id($pricingStructureReference/@href) instance of element(*, PricingStructure), $pricingStructureReference, ())
,
for $productReference as element(*, ProductReference) in //element(*, ProductReference)
return res:pretty-result(xs:NMTOKEN("ref-32"), id($productReference/@href) instance of element(*, Product), $productReference, ())
,
for $rateReference as element(*, RateReference) in //element(*, RateReference)
return res:pretty-result(xs:NMTOKEN("ref-33"), id($rateReference/@href) instance of element(*, Rate), $rateReference, ())
,
for $scheduleReference as element(*, ScheduleReference) in //element(*, ScheduleReference)
return res:pretty-result(xs:NMTOKEN("ref-34"), id($scheduleReference/@href) instance of element(*, Schedule), $scheduleReference, ())
,
for $spreadScheduleReference as element(*, SpreadScheduleReference) in //element(*, SpreadScheduleReference)
return res:pretty-result(xs:NMTOKEN("ref-35"), id($spreadScheduleReference/@href) instance of element(*, SpreadSchedule), $spreadScheduleReference, ())
,
for $sensitivitySetDefinitionReference as element(*, SensitivitySetDefinitionReference) in //element(*, SensitivitySetDefinitionReference)
return res:pretty-result(xs:NMTOKEN("ref-36"), id($sensitivitySetDefinitionReference/@href) instance of element(*, SensitivitySetDefinition), $sensitivitySetDefinitionReference, ())
,
for $anyAssetReference as element(*, AnyAssetReference) in //element(*, AnyAssetReference)
return res:pretty-result(xs:NMTOKEN("ref-37"), id($anyAssetReference/@href) instance of element(*, Leg) or id($anyAssetReference/@href) instance of element(*, Trade) or id($anyAssetReference/@href) instance of element(*, BasketConstituent), $anyAssetReference, ())
(: See issue http://www.fpml.org/issues/view.php?id=831
,
for $mandatoryEarlyTermination as element(*, MandatoryEarlyTermination) in //element(*, MandatoryEarlyTermination)
return res:pretty-result(xs:NMTOKEN("ref-38"), id($mandatoryEarlyTermination/cashSettlement/cashSettlementValuationDate/dateRelativeTo/@href) instance of element(*, mandatoryEarlyTerminationDate), $mandatoryEarlyTermination, ())
:)
,
for $businessCentersReference as element(*, BusinessCentersReference) in //element(*, BusinessCentersReference)
return res:pretty-result(xs:NMTOKEN("ref-39"), id($businessCentersReference/@href) instance of element(*, BusinessCenters), $businessCentersReference, ())

		}	
	}
};